#coding: latin-1

# PyOpenOffice Version 0.4
# Copyright (C) 2005: Martin Simon
# Homepage: www.bezirksreiter.de

## GNU LESSER GENERAL PUBLIC LICENSE
##		       Version 2.1, February 1999

## Copyright (C) 1991, 1999 Free Software Foundation, Inc.
##     51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
## Everyone is permitted to copy and distribute verbatim copies
## of this license document, but changing it is not allowed.

##[This is the first released version of the Lesser GPL.  It also counts
## as the successor of the GNU Library Public License, version 2, hence
## the version number 2.1.]

##			    Preamble

##  The licenses for most software are designed to take away your
##freedom to share and change it.  By contrast, the GNU General Public
##Licenses are intended to guarantee your freedom to share and change
##free software--to make sure the software is free for all its users.

##  This license, the Lesser General Public License, applies to some
##specially designated software packages--typically libraries--of the
##Free Software Foundation and other authors who decide to use it.  You
##can use it too, but we suggest you first think carefully about whether
##this license or the ordinary General Public License is the better
##strategy to use in any particular case, based on the explanations below.

##  When we speak of free software, we are referring to freedom of use,
##not price.  Our General Public Licenses are designed to make sure that
##you have the freedom to distribute copies of free software (and charge
##for this service if you wish); that you receive source code or can get
##it if you want it; that you can change the software and use pieces of
##it in new free programs; and that you are informed that you can do
##these things.

##  To protect your rights, we need to make restrictions that forbid
##distributors to deny you these rights or to ask you to surrender these
##rights.  These restrictions translate to certain responsibilities for
##you if you distribute copies of the library or if you modify it.

##  For example, if you distribute copies of the library, whether gratis
##or for a fee, you must give the recipients all the rights that we gave
##you.  You must make sure that they, too, receive or can get the source
##code.  If you link other code with the library, you must provide
##complete object files to the recipients, so that they can relink them
##with the library after making changes to the library and recompiling
##it.  And you must show them these terms so they know their rights.

##  We protect your rights with a two-step method: (1) we copyright the
##library, and (2) we offer you this license, which gives you legal
##permission to copy, distribute and/or modify the library.

##  To protect each distributor, we want to make it very clear that
##there is no warranty for the free library.  Also, if the library is
##modified by someone else and passed on, the recipients should know
##that what they have is not the original version, so that the original
##author's reputation will not be affected by problems that might be
##introduced by others.

##  Finally, software patents pose a constant threat to the existence of
##any free program.  We wish to make sure that a company cannot
##effectively restrict the users of a free program by obtaining a
##restrictive license from a patent holder.  Therefore, we insist that
##any patent license obtained for a version of the library must be
##consistent with the full freedom of use specified in this license.

##  Most GNU software, including some libraries, is covered by the
##ordinary GNU General Public License.  This license, the GNU Lesser
##General Public License, applies to certain designated libraries, and
##is quite different from the ordinary General Public License.  We use
##this license for certain libraries in order to permit linking those
##libraries into non-free programs.

##  When a program is linked with a library, whether statically or using
##a shared library, the combination of the two is legally speaking a
##combined work, a derivative of the original library.  The ordinary
##General Public License therefore permits such linking only if the
##entire combination fits its criteria of freedom.  The Lesser General
##Public License permits more lax criteria for linking other code with
##the library.

##  We call this license the "Lesser" General Public License because it
##does Less to protect the user's freedom than the ordinary General
##Public License.  It also provides other free software developers Less
##of an advantage over competing non-free programs.  These disadvantages
##are the reason we use the ordinary General Public License for many
##libraries.  However, the Lesser license provides advantages in certain
##special circumstances.

##  For example, on rare occasions, there may be a special need to
##encourage the widest possible use of a certain library, so that it becomes
##a de-facto standard.  To achieve this, non-free programs must be
##allowed to use the library.  A more frequent case is that a free
##library does the same job as widely used non-free libraries.  In this
##case, there is little to gain by limiting the free library to free
##software only, so we use the Lesser General Public License.

##  In other cases, permission to use a particular library in non-free
##programs enables a greater number of people to use a large body of
##free software.  For example, permission to use the GNU C Library in
##non-free programs enables many more people to use the whole GNU
##operating system, as well as its variant, the GNU/Linux operating
##system.

##  Although the Lesser General Public License is Less protective of the
##users' freedom, it does ensure that the user of a program that is
##linked with the Library has the freedom and the wherewithal to run
##that program using a modified version of the Library.

##  The precise terms and conditions for copying, distribution and
##modification follow.  Pay close attention to the difference between a
##"work based on the library" and a "work that uses the library".  The
##former contains code derived from the library, whereas the latter must
##be combined with the library in order to run.

##		  GNU LESSER GENERAL PUBLIC LICENSE
##   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

##  0. This License Agreement applies to any software library or other
##program which contains a notice placed by the copyright holder or
##other authorized party saying it may be distributed under the terms of
##this Lesser General Public License (also called "this License").
##Each licensee is addressed as "you".

##  A "library" means a collection of software functions and/or data
##prepared so as to be conveniently linked with application programs
##(which use some of those functions and data) to form executables.

##  The "Library", below, refers to any such software library or work
##which has been distributed under these terms.  A "work based on the
##Library" means either the Library or any derivative work under
##copyright law: that is to say, a work containing the Library or a
##portion of it, either verbatim or with modifications and/or translated
##straightforwardly into another language.  (Hereinafter, translation is
##included without limitation in the term "modification".)

##  "Source code" for a work means the preferred form of the work for
##making modifications to it.  For a library, complete source code means
##all the source code for all modules it contains, plus any associated
##interface definition files, plus the scripts used to control compilation
##and installation of the library.

##  Activities other than copying, distribution and modification are not
##covered by this License; they are outside its scope.  The act of
##running a program using the Library is not restricted, and output from
##such a program is covered only if its contents constitute a work based
##on the Library (independent of the use of the Library in a tool for
##writing it).  Whether that is true depends on what the Library does
##and what the program that uses the Library does.
  
##  1. You may copy and distribute verbatim copies of the Library's
##complete source code as you receive it, in any medium, provided that
##you conspicuously and appropriately publish on each copy an
##appropriate copyright notice and disclaimer of warranty; keep intact
##all the notices that refer to this License and to the absence of any
##warranty; and distribute a copy of this License along with the
##Library.

##  You may charge a fee for the physical act of transferring a copy,
##and you may at your option offer warranty protection in exchange for a
##fee.

##  2. You may modify your copy or copies of the Library or any portion
##of it, thus forming a work based on the Library, and copy and
##distribute such modifications or work under the terms of Section 1
##above, provided that you also meet all of these conditions:

##    a) The modified work must itself be a software library.

##    b) You must cause the files modified to carry prominent notices
##    stating that you changed the files and the date of any change.

##    c) You must cause the whole of the work to be licensed at no
##    charge to all third parties under the terms of this License.

##    d) If a facility in the modified Library refers to a function or a
##    table of data to be supplied by an application program that uses
##    the facility, other than as an argument passed when the facility
##    is invoked, then you must make a good faith effort to ensure that,
##    in the event an application does not supply such function or
##    table, the facility still operates, and performs whatever part of
##    its purpose remains meaningful.

##    (For example, a function in a library to compute square roots has
##    a purpose that is entirely well-defined independent of the
##    application.  Therefore, Subsection 2d requires that any
##    application-supplied function or table used by this function must
##    be optional: if the application does not supply it, the square
##    root function must still compute square roots.)

##These requirements apply to the modified work as a whole.  If
##identifiable sections of that work are not derived from the Library,
##and can be reasonably considered independent and separate works in
##themselves, then this License, and its terms, do not apply to those
##sections when you distribute them as separate works.  But when you
##distribute the same sections as part of a whole which is a work based
##on the Library, the distribution of the whole must be on the terms of
##this License, whose permissions for other licensees extend to the
##entire whole, and thus to each and every part regardless of who wrote
##it.

##Thus, it is not the intent of this section to claim rights or contest
##your rights to work written entirely by you; rather, the intent is to
##exercise the right to control the distribution of derivative or
##collective works based on the Library.

##In addition, mere aggregation of another work not based on the Library
##with the Library (or with a work based on the Library) on a volume of
##a storage or distribution medium does not bring the other work under
##the scope of this License.

##  3. You may opt to apply the terms of the ordinary GNU General Public
##License instead of this License to a given copy of the Library.  To do
##this, you must alter all the notices that refer to this License, so
##that they refer to the ordinary GNU General Public License, version 2,
##instead of to this License.  (If a newer version than version 2 of the
##ordinary GNU General Public License has appeared, then you can specify
##that version instead if you wish.)  Do not make any other change in
##these notices.

##  Once this change is made in a given copy, it is irreversible for
##that copy, so the ordinary GNU General Public License applies to all
##subsequent copies and derivative works made from that copy.

##  This option is useful when you wish to copy part of the code of
##the Library into a program that is not a library.

##  4. You may copy and distribute the Library (or a portion or
##derivative of it, under Section 2) in object code or executable form
##under the terms of Sections 1 and 2 above provided that you accompany
##it with the complete corresponding machine-readable source code, which
##must be distributed under the terms of Sections 1 and 2 above on a
##medium customarily used for software interchange.

##  If distribution of object code is made by offering access to copy
##from a designated place, then offering equivalent access to copy the
##source code from the same place satisfies the requirement to
##distribute the source code, even though third parties are not
##compelled to copy the source along with the object code.

##  5. A program that contains no derivative of any portion of the
##Library, but is designed to work with the Library by being compiled or
##linked with it, is called a "work that uses the Library".  Such a
##work, in isolation, is not a derivative work of the Library, and
##therefore falls outside the scope of this License.

##  However, linking a "work that uses the Library" with the Library
##creates an executable that is a derivative of the Library (because it
##contains portions of the Library), rather than a "work that uses the
##library".  The executable is therefore covered by this License.
##Section 6 states terms for distribution of such executables.

##  When a "work that uses the Library" uses material from a header file
##that is part of the Library, the object code for the work may be a
##derivative work of the Library even though the source code is not.
##Whether this is true is especially significant if the work can be
##linked without the Library, or if the work is itself a library.  The
##threshold for this to be true is not precisely defined by law.

##  If such an object file uses only numerical parameters, data
##structure layouts and accessors, and small macros and small inline
##functions (ten lines or less in length), then the use of the object
##file is unrestricted, regardless of whether it is legally a derivative
##work.  (Executables containing this object code plus portions of the
##Library will still fall under Section 6.)

##  Otherwise, if the work is a derivative of the Library, you may
##distribute the object code for the work under the terms of Section 6.
##Any executables containing that work also fall under Section 6,
##whether or not they are linked directly with the Library itself.

##  6. As an exception to the Sections above, you may also combine or
##link a "work that uses the Library" with the Library to produce a
##work containing portions of the Library, and distribute that work
##under terms of your choice, provided that the terms permit
##modification of the work for the customer's own use and reverse
##engineering for debugging such modifications.

##  You must give prominent notice with each copy of the work that the
##Library is used in it and that the Library and its use are covered by
##this License.  You must supply a copy of this License.  If the work
##during execution displays copyright notices, you must include the
##copyright notice for the Library among them, as well as a reference
##directing the user to the copy of this License.  Also, you must do one
##of these things:

##    a) Accompany the work with the complete corresponding
##    machine-readable source code for the Library including whatever
##    changes were used in the work (which must be distributed under
##    Sections 1 and 2 above); and, if the work is an executable linked
##    with the Library, with the complete machine-readable "work that
##    uses the Library", as object code and/or source code, so that the
##    user can modify the Library and then relink to produce a modified
##    executable containing the modified Library.  (It is understood
##    that the user who changes the contents of definitions files in the
##    Library will not necessarily be able to recompile the application
##    to use the modified definitions.)

##    b) Use a suitable shared library mechanism for linking with the
##    Library.  A suitable mechanism is one that (1) uses at run time a
##    copy of the library already present on the user's computer system,
##    rather than copying library functions into the executable, and (2)
##    will operate properly with a modified version of the library, if
##    the user installs one, as long as the modified version is
##    interface-compatible with the version that the work was made with.

##    c) Accompany the work with a written offer, valid for at
##    least three years, to give the same user the materials
##    specified in Subsection 6a, above, for a charge no more
##    than the cost of performing this distribution.

##    d) If distribution of the work is made by offering access to copy
##    from a designated place, offer equivalent access to copy the above
##    specified materials from the same place.

##    e) Verify that the user has already received a copy of these
##    materials or that you have already sent this user a copy.

##  For an executable, the required form of the "work that uses the
##Library" must include any data and utility programs needed for
##reproducing the executable from it.  However, as a special exception,
##the materials to be distributed need not include anything that is
##normally distributed (in either source or binary form) with the major
##components (compiler, kernel, and so on) of the operating system on
##which the executable runs, unless that component itself accompanies
##the executable.

##  It may happen that this requirement contradicts the license
##restrictions of other proprietary libraries that do not normally
##accompany the operating system.  Such a contradiction means you cannot
##use both them and the Library together in an executable that you
##distribute.

##  7. You may place library facilities that are a work based on the
##Library side-by-side in a single library together with other library
##facilities not covered by this License, and distribute such a combined
##library, provided that the separate distribution of the work based on
##the Library and of the other library facilities is otherwise
##permitted, and provided that you do these two things:

##    a) Accompany the combined library with a copy of the same work
##    based on the Library, uncombined with any other library
##    facilities.  This must be distributed under the terms of the
##    Sections above.

##    b) Give prominent notice with the combined library of the fact
##    that part of it is a work based on the Library, and explaining
##    where to find the accompanying uncombined form of the same work.

##  8. You may not copy, modify, sublicense, link with, or distribute
##the Library except as expressly provided under this License.  Any
##attempt otherwise to copy, modify, sublicense, link with, or
##distribute the Library is void, and will automatically terminate your
##rights under this License.  However, parties who have received copies,
##or rights, from you under this License will not have their licenses
##terminated so long as such parties remain in full compliance.

##  9. You are not required to accept this License, since you have not
##signed it.  However, nothing else grants you permission to modify or
##distribute the Library or its derivative works.  These actions are
##prohibited by law if you do not accept this License.  Therefore, by
##modifying or distributing the Library (or any work based on the
##Library), you indicate your acceptance of this License to do so, and
##all its terms and conditions for copying, distributing or modifying
##the Library or works based on it.

##  10. Each time you redistribute the Library (or any work based on the
##Library), the recipient automatically receives a license from the
##original licensor to copy, distribute, link with or modify the Library
##subject to these terms and conditions.  You may not impose any further
##restrictions on the recipients' exercise of the rights granted herein.
##You are not responsible for enforcing compliance by third parties with
##this License.

##  11. If, as a consequence of a court judgment or allegation of patent
##infringement or for any other reason (not limited to patent issues),
##conditions are imposed on you (whether by court order, agreement or
##otherwise) that contradict the conditions of this License, they do not
##excuse you from the conditions of this License.  If you cannot
##distribute so as to satisfy simultaneously your obligations under this
##License and any other pertinent obligations, then as a consequence you
##may not distribute the Library at all.  For example, if a patent
##license would not permit royalty-free redistribution of the Library by
##all those who receive copies directly or indirectly through you, then
##the only way you could satisfy both it and this License would be to
##refrain entirely from distribution of the Library.

##If any portion of this section is held invalid or unenforceable under any
##particular circumstance, the balance of the section is intended to apply,
##and the section as a whole is intended to apply in other circumstances.

##It is not the purpose of this section to induce you to infringe any
##patents or other property right claims or to contest validity of any
##such claims; this section has the sole purpose of protecting the
##integrity of the free software distribution system which is
##implemented by public license practices.  Many people have made
##generous contributions to the wide range of software distributed
##through that system in reliance on consistent application of that
##system; it is up to the author/donor to decide if he or she is willing
##to distribute software through any other system and a licensee cannot
##impose that choice.

##This section is intended to make thoroughly clear what is believed to
##be a consequence of the rest of this License.

##  12. If the distribution and/or use of the Library is restricted in
##certain countries either by patents or by copyrighted interfaces, the
##original copyright holder who places the Library under this License may add
##an explicit geographical distribution limitation excluding those countries,
##so that distribution is permitted only in or among countries not thus
##excluded.  In such case, this License incorporates the limitation as if
##written in the body of this License.

##  13. The Free Software Foundation may publish revised and/or new
##versions of the Lesser General Public License from time to time.
##Such new versions will be similar in spirit to the present version,
##but may differ in detail to address new problems or concerns.

##Each version is given a distinguishing version number.  If the Library
##specifies a version number of this License which applies to it and
##"any later version", you have the option of following the terms and
##conditions either of that version or of any later version published by
##the Free Software Foundation.  If the Library does not specify a
##license version number, you may choose any version ever published by
##the Free Software Foundation.

##  14. If you wish to incorporate parts of the Library into other free
##programs whose distribution conditions are incompatible with these,
##write to the author to ask for permission.  For software which is
##copyrighted by the Free Software Foundation, write to the Free
##Software Foundation; we sometimes make exceptions for this.  Our
##decision will be guided by the two goals of preserving the free status
##of all derivatives of our free software and of promoting the sharing
##and reuse of software generally.

##			    NO WARRANTY

##  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO
##WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.
##EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
##OTHER PARTIES PROVIDE THE LIBRARY "AS IS" WITHOUT WARRANTY OF ANY
##KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
##IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
##PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
##LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME
##THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

##  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
##WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
##AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU
##FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR
##CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
##LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
##RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
##FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
##SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
##DAMAGES.

##		     END OF TERMS AND CONDITIONS

##           How to Apply These Terms to Your New Libraries

##  If you develop a new library, and you want it to be of the greatest
##possible use to the public, we recommend making it free software that
##everyone can redistribute and change.  You can do so by permitting
##redistribution under these terms (or, alternatively, under the terms of the
##ordinary General Public License).

##  To apply these terms, attach the following notices to the library.  It is
##safest to attach them to the start of each source file to most effectively
##convey the exclusion of warranty; and each file should have at least the
##"copyright" line and a pointer to where the full notice is found.

##    <one line to give the library's name and a brief idea of what it does.>
##    Copyright (C) <year>  <name of author>

##    This library is free software; you can redistribute it and/or
##    modify it under the terms of the GNU Lesser General Public
##    License as published by the Free Software Foundation; either
##    version 2.1 of the License, or (at your option) any later version.

##    This library is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
##    Lesser General Public License for more details.

##    You should have received a copy of the GNU Lesser General Public
##    License along with this library; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

##Also add information on how to contact you by electronic and paper mail.

##You should also get your employer (if you work as a programmer) or your
##school, if any, to sign a "copyright disclaimer" for the library, if
##necessary.  Here is a sample; alter the names:

##  Yoyodyne, Inc., hereby disclaims all copyright interest in the
##  library `Frob' (a library for tweaking knobs) written by James Random Hacker.

##  <signature of Ty Coon>, 1 April 1990
##  Ty Coon, President of Vice

##That's all there is to it!


import sys
import re
import string
import types
import os
import glob
import shutil
import time
import copy
import xml.sax
import xml.sax.handler
from xml.sax.saxutils import escape
import zipfile
#import shelve
import reportlab.platypus
import cPickle

import textutilities_pyopenoffice
try:
     import patched_trml2pdf
except:
     # without XSLT - for the "Bezirksreiter" for example
     pass

from reportlab.platypus import SimpleDocTemplate, BaseDocTemplate,Paragraph,PageTemplate,Spacer,Frame,Table,TableStyle,KeepTogether,PageBreak,ActionFlowable,Image,NextPageTemplate,CondPageBreak
from reportlab.platypus.doctemplate import IndexingFlowable
from reportlab.lib.styles import getSampleStyleSheet
from reportlab.rl_config import defaultPageSize
from reportlab.lib.pagesizes import A4,A5,landscape,portrait
from reportlab.lib.units import inch, cm
from reportlab.lib import colors

# TODO:
# A trial for better split capabilities - not very successful yet...

##class customParagraph(reportlab.platypus.Paragraph):
##     def __init__(self, text, style, bulletText = None, frags=None, caseSensitive=1):
##          reportlab.platypus.Paragraph.__init__(self, text, style, bulletText = None, frags=None, caseSensitive=1)
     
##     def split(self,availWidth,availHeight):
##          #print "hallo"
##          #print availWidth,availHeight
##          reportlab.platypus.Paragraph.split(self,availWidth,availHeight)

##     def breakLines(self,width):
##          temp = reportlab.platypus.Paragraph.breakLines(self,width)
##          #print "###############"
##          #print temp
##          return temp

##     def wrap(self, availWidth, availHeight):
##          temp= reportlab.platypus.Paragraph.wrap(self, availWidth, availHeight)
##          #print "set: ", temp
##          #print "actual: ",self.getActualLineWidths0()
##          return temp



try:
     # Imports for the "Bezirkreiter"-Software
     import normalDate
     import datumutilities
     import verschiedeneUtilities
     import sortieren
except:
     pass

PAGE_HEIGHT=defaultPageSize[1]
PAGE_WIDTH = defaultPageSize[0]
STYLES = getSampleStyleSheet()
SKIP={"underline": 0,"images": 0,"tables": 0, "all": 0}
VERBOSE = 0
# be careful with the globals when deriving classes!

def plattformTesten():
    """Tests the current platform: win95, winNT, other.""" 
    win = 0
    win_nt = 0
    try:
        if sys.platform[:3] == "win":
            win = 1
            try:
                if (os.environ["OS"].lower()).find("nt") != -1 and win:
                    # os.environ["OS"] nicht unter Linux und Win95!
                    win_nt = 1
            except:
                pass
    except:
        pass
    return win, win_nt

class Regexes:
     def __init__(self):
        self.datumsform = re.compile(r"((\d?\d)\.\s?(\d?\d)\.\s?(\d\d\d\d))")
        self.datumstext = re.compile(r"((\d?\d)\.\s?(Januar|Februar|März|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember)\s?(\d\d\d\d))")
        self.monate = {"Januar":"01", "Februar":"02", "März":"03", "April":"04","Mai":"05","Juni":"06","Juli":"07","August":"08","September":"09","Oktober":"10","November":"11","Dezember":"12"}

# ********* Textutilities Class and global "defaultkeywords" now in textutilities_pyopenoffice.py **************


class ooDocTemplate(BaseDocTemplate):
   def __init__(self,filename,LANDSCAPE=0,pageFormat={},**kwargs):
      """Make a page template."""  
      apply(BaseDocTemplate.__init__,(self,filename),kwargs)
      self.text_width = 17*cm
      pagetemplate_ok = 0
      try:
           if pageFormat != {}:
                frame3 = Frame(x1=pageFormat["x1"],y1=pageFormat["y1"],width=pageFormat["text_width"],height=pageFormat["text_height"],id="4")
                pt1 = PageTemplate(id="OneColumn",frames=[frame3],pagesize=(pageFormat["width"],pageFormat["height"]))
                pagetemplate_ok = 1
                self.text_width = pageFormat["text_width"]
      except:
           pass
      if not pagetemplate_ok and LANDSCAPE:
           self.text_width = 26.5*cm
           frame3 = Frame(x1=1.5*cm,y1=2*cm,width=self.text_width,height=17*cm,id="4")
           pt1 = PageTemplate(id="OneColumn",frames=[frame3],pagesize=landscape(A4))
      elif not pagetemplate_ok:
           frame3 = Frame(x1=2*cm,y1=1.5*cm,width=self.text_width,height=26.5*cm,id="4")
           pt1 = PageTemplate(id="OneColumn",frames=[frame3])
      self.addPageTemplates(pt1)
      self.stylesheet = getSampleStyleSheet()
      self.stylesheet_info = {"Normal": {"bold": 0,"italic": 0, "underline": 0}}
      self.stylesheet_info["Table Contents"] = self.stylesheet_info["Normal"]
      # font-weight etc. for paragraphs added for Platypus-XML-Markup
      self.tablestyle_border = {}
      # Table with border?
      self.table_stylesheet = {}
      self.table_stylesheet["Normal"] =  [("ALIGN",(0,0),(-1,-1),"LEFT"),
                                          ("VALIGN",(0,0),(-1,-1),"TOP")]
      self.tablecell_styles = {}
      # containing the styles of single cells
      self.tablecolumn_styles = {}
      # containing the column styles defined in "styles:properties"
      # this dict is built during the parsing of the "automatic-styles" section.
      # the keys are the table-column style names.
      self.tablecolumn_widths = {}
      # containing the list of table column widths of a table defined by
      # <table:table-column...> according to self.tablecolumn_styles
      # the keys are the table names!
      self.style = self.stylesheet["Normal"]
      # TODO: always the default for tables?
      tempstyle = copy.copy(self.style)
      tempstyle.name = "Table Contents"
      self.stylesheet.add(tempstyle)
      self.style_body = self.stylesheet["BodyText"]
      self.style_h3 = self.stylesheet["Heading3"]
      self.stylesheet["Heading1"].spaceBefore = 14
      self.textMarkupStyles = {} # <font face="times"> etc.

class oo2pdf:
   """This class is responsible for the OO-to-PDF transformation. It builds up the "story" for the Platypus engine.
   Mind the different SKIP-flags."""
   global SKIP
   
   # def __init__(self,filename="test.pdf",LANDSCAPE=0,contentDOM=None,stylesDOM=None):
   def __init__(self,filename="test.pdf",LANDSCAPE=0,DOM=None):
      self.Story = []
      self.DOM = DOM
      # TODO: new dom api
      #self.contentDOM = contentDOM
      #self.stylesDOM = stylesDOM
      self.filename = filename
      self.pageFormat = self.mapPageFormat()
      self.doc = ooDocTemplate(self.filename,LANDSCAPE=LANDSCAPE,pageFormat=self.pageFormat)
      self.markups = {"bold": ("""<b>""","""</b>"""),"italic": ("""<i>""","""</i>"""),"underline": ("""<u>""","""</u>""")}
      self.test_text1 = """text with German <i>Umlaute</i>""" + escape("&") + """XML-entity and <b>XML-Markup</b>: üäÄßö&quot;"""
      # mind the quoting
      self.skip = SKIP
      # for difficult cases
      self.Images = {}
      # used for caching of Image-Flowables

   def mapPageFormat(self):
        """Get the page format "style:page-master" from styles.xml."""
        values = ("fo:page-width","fo:page-height","fo:margin-top","fo:margin-bottom","fo:margin-left","fo:margin-right")
        pagedict = {}
        pagedict_reportlab = {}
        for v in values:
             temp = self.DOM.getPageMasterProperty(v)
             if temp == "":
                  # if at least one value could not be retrieved:
                  # return empty dictionary => standard page size is use.
                  return {}
             pagedict[v] = self.mapUnits(temp)
        # TODO: something wrong with the left margin?
        try:
            pagedict_reportlab["width"] = pagedict["fo:page-width"]
            pagedict_reportlab["height"] = pagedict["fo:page-height"]
            pagedict_reportlab["x1"] = pagedict["fo:margin-left"]
            pagedict_reportlab["y1"] = pagedict["fo:margin-bottom"]
            pagedict_reportlab["text_width"] = pagedict["fo:page-width"]-pagedict["fo:margin-left"]-pagedict["fo:margin-right"]
            pagedict_reportlab["text_height"] = pagedict["fo:page-height"]-pagedict["fo:margin-bottom"]-pagedict["fo:margin-top"]
            return pagedict_reportlab
        except:
            return {} 
            
             

   def distancePoint(self,length=1,color="white",token=" "):
      """Produces a non-visible point, uses XML-Markup. For "Tabs" etc."""
      # TODO
      points = token * length
      return """<font color="%s">%s</font>""" % (color,points)

   def addParagraphStyle(self,stylename,styledict={"fontName": "Times-Roman"}):
      """Add a new Paragraph Style to doc.stylesheet."""
      tempstyle = copy.copy(self.doc.style)
      #stylename = string.replace(stylename,"Heading ","Heading")
      # use styles from styles.xml instead
      self.doc.stylesheet_info[stylename] = {}
      for a in self.markups.keys():
         self.doc.stylesheet_info[stylename][a] = styledict.get(a,0)
      self.doc.stylesheet_info[stylename]["pageBreak"] = styledict.get("pageBreak")
      for k in styledict.keys():
         if not self.markups.has_key(k):
            tempstyle.__dict__[k] = styledict[k]
            # print tempstyle.__dict__
      tempstyle.name = stylename
      tempstyle.leading = tempstyle.fontSize + int(tempstyle.fontSize/5) + 1
      if styledict.has_key("background-color"):
           tempstyle.backColor = styledict["background-color"]
      # print tempstyle.__dict__
      self.doc.stylesheet.add(tempstyle)

   def addTextStyle(self,stylename,oo_attrs,currentParagraphStyle=""):
      """Make XML-Markup-Tags from OO-text-styles. Used for intra-paragraph-markup.
      Problems with underlining (lines too short) - probably from a bug in the Platypus engine."""
      # print currentParagraphStyle
      italic_flag = 0
      temptext = """%s"""
      if oo_attrs.get("fo:font-style") == "italic":
         temptext = """<i>%s</i>""" % temptext
         italic_flag = 1
      if oo_attrs.get("fo:font-weight") == "bold":
         temptext = """<b>%s</b>""" % temptext
      if oo_attrs.get("style:text-underline") == "single":
         # TODO: ... and not...  but so it seems to work...
         if SKIP.get("underline"): #and not italic_flag:
            temptext = """<i>%s</i>""" % temptext
         else:
            temptext = """<u>%s</u>""" % temptext
      temp = ""
      size = oo_attrs.get("fo:font-size","nothing")
      if size[-2:] == "pt":
         temp = """size=%s""" % int(size[:-2])
      font = oo_attrs.get("style:font-name","")
      if font:
         temp += """ name="%s" """ % self.mapFontName(font)
      if temp:
         temptext = """<font %s>%s</font>""" % (temp,temptext)
      self.doc.textMarkupStyles[stylename]  = temptext

   def mapFontName(self,fontname):
      """Map the OO-Fonts to the standard fonts found in ReportLab."""
      if string.find(fontname,"Helvetica") != -1 or string.find(fontname,"Arial") != -1 or string.find(fontname,"Bitstream Vera Sans") != -1:
         return "Helvetica"
      if string.find(fontname,"Courier") != -1:
         return "Courier"
      else:
         return "Times-Roman"

   def updateTableStyle(self,table_stylename,cell_stylename,row,column):
      """Add cell formatting for a certain table cell."""
      #print cell_stylename,row,column
      if not self.doc.table_stylesheet.has_key(table_stylename):
           self.doc.table_stylesheet[table_stylename] = []
      tempstyle = self.doc.tablecell_styles.get(cell_stylename,[])
      newstyle = []
      for i in tempstyle:
           newstyle.append((i[0],(column,row),(column,row),i[3]))
      #print table_stylename,cell_stylename,newstyle
      self.doc.table_stylesheet[table_stylename] += newstyle
      

   def mapParagraphStyle(self,stylename,oo_attrs=None):
      """Map the OO-automatic-styles to Reportlab-ParagraphStyles"""
      # TODO: Limitation: the entire OO-document must be formatted with the "Standard"-Paragraph-Style.
      # This function only maps the local(!) automatic-styles.
      # => TODO: get preprocessed oo_attrs according to the style hierarchy.
      # TODO: Test the preprocessed oo_attrs
      #print oo_attrs
      #new_oo_attrs = self.DOM.style_properties_hierarchical[stylename]
      # stop! this was only experimental...
      
      new_oo_attrs = oo_attrs
      
      #print "Stil: ",stylename
      #print new_oo_attrs
      styledict = {}
      # TODO: the paragraph background color does not have the exact text-width.
      # This seems to be a Platypus-Bug.
      if new_oo_attrs.has_key("fo:background-color"):
           try:
                styledict["background-color"] = colors.HexColor(new_oo_attrs["fo:background-color"].encode("latin-1"))
           except:
                pass
      if new_oo_attrs.get("fo:font-style") == "italic":
         styledict["italic"] = 1
      if new_oo_attrs.get("fo:font-weight") == "bold":
         styledict["bold"] = 1
      if new_oo_attrs.get("style:text-underline") == "single":
         if SKIP.get("underline"):
            styledict["italic"] = 1
         else:
            styledict["underline"] = 1
      if (new_oo_attrs.get("fo:break-before") == "page") or (new_oo_attrs.get("fo:break-after") == "page"):
         styledict["pageBreak"] = 1
      else:
         styledict["pageBreak"] = 0
      size = new_oo_attrs.get("fo:font-size","nothing")
      if size[-2:] == "pt":
         styledict["fontSize"] = int(size[:-2])
      font = new_oo_attrs.get("style:font-name","")
      # TODO: map the fontname to reportlab-fonts
      #if font:
      #   styledict["fontName"] = ("%s" % font).encode("latin-1") # convert from unicode
      styledict["fontName"] = self.mapFontName(font)
      styledict["alignment"] = self.mapParagraphAlignment(new_oo_attrs)
      if styledict["alignment"] == 4:
           SKIP["underline"] = 1
           # in a document with justified paragraphs never use underline -
           # it is a Platypus bug.
      #styledict["fontName"] = "Helvetica"
      return styledict

   def mapParagraphAlignment(self,oo_attrs):
      """Map the text alignment for the Platypus-Engine."""
      map = {"start": 0, "center": 1, "end": 2, "justify": 4}
      return map[oo_attrs.get("fo:text-align","start").encode("latin-1")]

   def mapPictureStyle(self,oo_attrs):
      """Map a picture-style, use very few attributes. Only works with embedded (not linked) pictures.
      TODO: Only works with cm and inch."""
      tempdict = {}
      #tempdict["filename"] = string.replace(oo_attrs.get("xlink:href","xxxxxxxxxxxxxxxxxx"),"""#Pictures/""","")
      tempdict["width"] = oo_attrs.get("svg:width",None) # use the default for Platypus      
      tempdict["height"] = oo_attrs.get("svg:height",None)
     ## for k in ("width","height"):
##         try:
##            tempdict[k] = float(string.replace(tempdict[k],"cm",""))
##         except:
##            tempdict[k] = float(string.replace(tempdict[k],"inch",""))
      return tempdict

   def normalizeTableContent(self,tableContent):
      """Normalizes tables with different row lengthes."""
      max_length = max([len(i) for i in tableContent])
      temp_content = []
      for c in tableContent:
         while len(c) < max_length:
            c.append(self.addEmptyParagraph("Normal",return_not_add=1))
         temp_content.append(c)
      return temp_content

   def normalizeTableColumns(self,cols):
        """Normalize the table column width according to page text width."""
        sum = reduce(lambda x,y: x+y,cols)
        factor = self.doc.text_width / sum
        return map(lambda x: x*factor,cols)        

   def addTable(self,tableContent,stylename):
      """Adds a hardcoded, simple-style table with or without a grid, the whole table with hAlign=LEFT."""
      colwidths = self.doc.tablecolumn_widths.get(stylename)
      if self.pageFormat == {}:
           colwidths = self.normalizeTableColumns(colwidths)
           # use standardized colwidths when no exact page format could be retrieved.
      tableContent = self.normalizeTableContent(tableContent)
      tempstyle = [("ALIGN",(0,0),(-1,-1),"LEFT"),
                   ("VALIGN",(0,0),(-1,-1),"TOP")]
      add = self.doc.table_stylesheet.get(stylename)
     ## try:
##           tempstyle.append(add[0])
##      except:
##           pass
      tempstyle += add
      if self.doc.tablestyle_border.get(stylename):
         tempstyle.append(("GRID",(0,0),(-1,-1),0.5,colors.black))
      #print "tempstyle", stylename
      #tempstyle.append(("BACKGROUND",(2,1),(2,1),colors.Color(0,1,0)))
      #print tempstyle
      #table = Table(data,colWidths=3*[3*cm],style=tempstyle)
      cols = colwidths
      #cols = None
      try:
           table = Table(data=tableContent,colWidths=cols,style=tempstyle)
      except:
           table = Table(data=tableContent,colWidths=None,style=tempstyle)
      table.hAlign = "LEFT" # alignment of the whole table
      # Test:
      ##for r in tableContent:
##         counter = 1
##         for c in r:
##            print c
##            print "Number %s ------------------" % counter
##            counter += 1
##         print "##########################"
      self.Story.append(table)

   def addPicture(self,oo_attrs,picture_filename,picture_content,return_not_add=0):
      """Add a picture flowable to the "Story"."""
      if not os.path.exists(picture_filename):
         file = open(picture_filename,"wb") # make a temporary picture file
         file.write(picture_content)
         file.close()
      tempdict = self.mapPictureStyle(oo_attrs)
      picture = None
      new_cache = 1
      new_flowable = 1
      if self.Images.has_key(picture_filename):
         temp_pic = self.Images[picture_filename]
         new_cache = 0
         if temp_pic["width"] == tempdict["width"] and temp_pic["height"] == tempdict["height"]:
            new_flowable = 0
      if new_flowable:
         ##unit = cm
##         temp = {"width": 0, "height": 0}
##         for k in ("width","height"):
##              try:
##                   temp[k] = float(string.replace(tempdict[k],"cm",""))
##              except:
##                   temp[k] = float(string.replace(tempdict[k],"inch",""))
##                   unit = inch
         width = self.mapUnits(tempdict["width"])
         height = self.mapUnits(tempdict["height"])
         picture = Image(picture_filename,width=width,height=height)
      elif (not new_cache) and (not new_flowable):
         picture = self.Images[picture_filename]["picture"]
         # just use the reference - and Story.build() will render much faster.
         # print "image cache used"
      if new_flowable and new_cache:
         # do not make two caches of the same filename!
         self.Images[picture_filename] = {"picture": picture,"width": tempdict["width"], "height": tempdict["height"]}
      # TODO:
      #picture.hAlign = "CENTER" # only hardcoded  
      if return_not_add:
         return picture
      else:
         self.Story.append(picture)

   def mapUnits(self,s):
        """Maps "cm" and "inch" to Reportlab-Units or simple floats. TODO: Very primitive."""
        try:
             return float(string.replace(s,"cm","")) * cm
        except:
             return float(string.replace(s,"inch","")) * inch

   def addParagraph(self,text,stylename,bullet="",orderedList=1,return_not_add=0):
      """Add a paragraph to the Platypus-"Story". It can be (formatted) text, a bulleted list or an ordered list.
      Use return_not_add=1 for just getting the Paragraph object, without adding it to the story."""
      # TODO: Headings
      try:
	 # TODO: 
         stylename = string.replace(stylename,"Heading ","Heading")
         # A way for very simple headings
         tempstyle = copy.copy(self.doc.stylesheet[stylename]) # beware of reference-only "copies"...
      except:
         stylename = "Normal"
         tempstyle = copy.copy(self.doc.stylesheet[stylename])          
      temptext = copy.copy(text)
      for a in self.markups.keys():
         try:
            if self.doc.stylesheet_info[stylename][a]:
               distance_token = " "
               if a == "underline":
                    distance_token = "."
               # TODO: change the workaround?
               # TODO: mind the distancePoint is always white.
               temptext = """%s%s%s%s""" % (self.markups[a][0],temptext,self.markups[a][1],self.distancePoint(token=distance_token))
               #temptext = """%s%s<font color="white">.</font>%s""" % (self.markups[a][0],temptext,self.markups[a][1])
               # the underline <u> - tag may not enclose a whole paragraph (a reportlab bug). Workaround: insert a white token.
         except:
            # when no stylesheet_info was generated
            pass
      ##try:
##         if self.doc.stylesheet_info[stylename]["pageBreak"]:
##            self.Story.append(PageBreak())
##      except:
##         pass
      if bullet:
         tempstyle.leftIndent = 15
         tempstyle.bulletIndent = 0
         tempstyle.bulletFontSize = tempstyle.fontSize
         if not orderedList:
            # need to change the bulletFontName last!
            tempstyle.bulletFontName = "Symbol"
            bullet = "\267"
         if return_not_add:
            return Paragraph(temptext,tempstyle,bullet) # used for tables etc.
         else:
            self.Story.append(Paragraph(temptext,tempstyle,bullet))
      else:
         if return_not_add:
            return Paragraph(temptext,tempstyle)
         else:
            self.Story.append(Paragraph(temptext,tempstyle))

   def addEmptyParagraph(self,stylename,return_not_add=0):
      text = self.distancePoint()
      try:
         tempstyle = self.doc.stylesheet[stylename]
      except:
         tempstyle = self.doc.stylesheet["Normal"]
      if return_not_add:
         return Paragraph(text,tempstyle)
      else:
         self.Story.append(Paragraph(text,tempstyle))

   def testTable(self):
      """A test function for Platypus tables."""
      data = [["1","2","3"],
              ["1","2","3"],
              ["1","2","3"]]
      tempstyle = [("GRID",(0,0),(-1,-1),0.5,colors.black),
                   ("ALIGN",(0,0),(-1,-1),"LEFT")]
      #table = Table(data,colWidths=3*[3*cm],style=tempstyle)
      table = Table(data,style=tempstyle)
      table.hAlign = "LEFT"
      self.Story = [table] + self.Story

   def mapTableStyle(self,stylename,oo_attrs):
      """TODO: do not map only the column-widths.
      stylename is the current table stylename."""
      if not self.doc.tablecolumn_widths.has_key(stylename):
           self.doc.tablecolumn_widths[stylename] = []
      colstyle = oo_attrs.get("table:style-name").encode("latin-1")
      width = self.doc.tablecolumn_styles[colstyle]["width"]
      number = [0]
      if oo_attrs.has_key("table:number-columns-repeated"):
           number = range(int(oo_attrs["table:number-columns-repeated"]))
      for i in number:
           self.doc.tablecolumn_widths[stylename].append(width)           

   def addTableColumnStyle(self,stylename,oo_attrs):
        """Adds a table-column style.
        TODO: only column width implemented yet."""
        # TODO: are there column-styles without width?
        value = self.mapUnits(oo_attrs["style:column-width"])
        self.doc.tablecolumn_styles[stylename] = {"width": value}
        # the value is stored in points calculated by mapUnits.
        

   def addTableCellStyle(self,stylename,oo_attrs):
      """Adds a table-cell style as a list of TableStyle Commands.""" 
      self.doc.tablecell_styles[stylename] = []
      tempstyle = []
      if oo_attrs.has_key("fo:background-color"):
           stringcolor = oo_attrs["fo:background-color"].encode("latin-1")
           try:
                tempcolor = colors.HexColor(stringcolor)
                tempstyle.append(("BACKGROUND",(None,None),(None,None),tempcolor))
                # You have to replace the dummy tuples later for the positioning!)
           except:
                pass # only correct hexcolors accepted
      self.doc.tablecell_styles[stylename] += tempstyle
      #print "new style ",stylename
      #print self.doc.tablecell_styles[stylename]
           

   def buildStory(self):
      self.doc.build(self.Story)
          

class oo2pdfHandler(xml.sax.handler.ContentHandler):
    """Specialized handler for the sax parser.
    TODO: Page numbering, better table formatting..."""

    def __init__(self,infile="test.sxw",outfile=None):
       self.infile = infile
       self.outfile = ""
       if outfile is None:
          self.outfile = self.infile[:-3]+"pdf"
       # DOM-Api changed!!! =>
       self.DOM = textutilities_pyopenoffice.DomApi(xml_content=self.readContent("content.xml"),xml_styles=self.readContent("styles.xml"))
       #self.contentDOM = textutilities_pyopenoffice.DomApi(self.readContent("content.xml"))
       #self.stylesDOM = textutilities_pyopenoffice.DomApi(self.readContent("styles.xml"))
       # self.oo2pdf = oo2pdf(self.outfile,LANDSCAPE=self.testLandscape(),contentDOM=self.contentDOM,stylesDOM=self.stylesDOM)
       self.oo2pdf = oo2pdf(self.outfile,LANDSCAPE=self.testLandscape(),DOM=self.DOM)
       # Flags for the saxparser:
       self.inParagraph = 0
       self.inIntraParagraphMarkup = 0
       self.inTable = 0
       self.inColumn = 0
       self.inHeaderRows = 0
       self.inRow = 0
       self.inCell = 0
       self.inStyle = 0
       self.inParagraphStyle = 0
       self.inTextStyle = 0
       self.inTableCellStyle = 0
       self.inTableColumnStyle = 0
       self.inUnorderedList = 0
       self.inOrderedList = 0
       self.orderedListCounter = 0
       self.inListItem = 0
       self.inDropIt = 0
       self.imageAdded = 0
       self.emptyParagraph = 0
       self.tabStop = 0
       self.text = ""
       #self.tableText = ""
       self.currentStylename = ""
       self.currentParagraphStyle = ""
       self.currentTableStyle = ""
       self.currentTableColumnStyle = ""
       self.currentTableCellStyle = ""
       self.currentTextStyle = ""
       self.currentParagraphText = ""
       self.currentListItemText = ""
       self.currentTableContent = []
       self.currentRowContent = []
       self.currentCellContent = []
       self.tableRowCounter = 0
       self.tableColumnCounter = 0
       self.currentPictureAttrs = {}
       self.pictureFiles = {}
       self.pageStyles = {}
       # TODO: init o.k.?
       # => was only experimental - switched off again
       # self.initStyles()
       # styles now form styles.xml
       xml.sax.handler.ContentHandler.__init__(self)

    def initStyles(self):
        # Experimental - switched off by default 
	# TODO: add other styles
	for style in self.DOM.style_dict.keys():
	    value = self.DOM.style_dict[style]
	    if value.getAttribute("style:family") == "paragraph":
		styledict = self.oo2pdf.mapParagraphStyle(stylename=style)
	        self.oo2pdf.addParagraphStyle(style,styledict)

    def  readContent(self,file="content.xml"):
       """read content-xml from the sxw-zip-archive"""
       z = zipfile.ZipFile(self.infile,"r")
       content = z.read(file)
       z.close()
       return content

    def testLandscape(self):
       """Test the styles.xml for landscape. TODO: very primitive."""
       styles = self.readContent(file="styles.xml")
       if styles.find("style:print-orientation=\"landscape\"") != -1:
            return 1
       else:
            return 0

    def readPicture(self,picture):
       """read a picture from Pictures/ in the sxw-zip-archive."""
       z = zipfile.ZipFile(self.infile,"r")
       try:
          content = z.read("Pictures/" + picture)
          z.close()
          return content
       except:
          z.close()
          return None

    def setTableBorder(self,attrs):
       """If at last one table cell of the oo-table has a border, in pdf the whole table is printed with a grid.
       TODO: Too primitive?"""
       for a in attrs.keys():
          a = a.encode("latin-1")
          if string.find(a,"fo:border") != -1:
             if (attrs[a].encode("latin-1")).lower() != "none":
                # use "Table1" from "Table1.A1" etc.
                self.oo2pdf.doc.tablestyle_border[self.currentTableStyle] = 1

    def startElement(self,name,attrs):
        """Custom style function for the "startElement"-event.
        Transform unicode always to latin-1 - do not use it for Asian fonts etc."""
        # TODO:
        if 1:
            if name == "text:h":
               # TODO: Do not handle headings always like paragraphs.
               # This is a workaround - otherwise you get into trouble with the "underline"-Attribute.
               name = "text:p"
            if name == "text:p":
                self.currentParagraphStyle = attrs.get("text:style-name","Normal").encode("latin-1")
                # TODO: what about empty paragraph-tags = newline like <text:p ......... />?                
                try:
                   if self.oo2pdf.doc.stylesheet_info[self.currentParagraphStyle]["pageBreak"]:
                      self.oo2pdf.Story.append(PageBreak())
                except:
                   pass
                self.inParagraph = 1
                self.emptyParagraph = 1
		# TODO: Headings
                temp = attrs.get("text:level")
                if temp in ("1","2","3"):
                   self.currentParagraphStyle = "Heading" + temp
                   # TODO: very primitive...
                self.currentParagraphText = ""
            elif name == "text:span":
               self.currentTextStyle = attrs.get("text:style-name","Normal").encode("latin-1")
               self.inIntraParagraphMarkup = 1
            elif name == "table:table":
                self.inTable = 1
                self.currentTableContent = []
                self.currentTableStyle = attrs.get("table:style-name").encode("latin-1")
                self.tableRowCounter = -1 # see below: begin counting with 0, not 1!                
            elif name == "table:table-column":
                 self.inColumn = 1
                 self.handleTableColumn(attrs)
            elif name == "table:table-header-rows":
                 # TODO: to be implemented
                 self.inHeaderRows = 1
            elif name == "table:table-row":
                self.inRow = 1
                self.currentRowContent = []
                self.tableRowCounter += 1
                #print "table:table-row",self.tableRowCounter
                self.tableColumnCounter = -1 # reset
            elif name == "table:table-cell":
                self.currentCellContent = []
                self.currentTableCellStyle = attrs.get("table:style-name","Normal").encode("latin-1")
                # "Normal" for exceptions
                self.inCell = 1
                self.tableColumnCounter += 1
            elif name == "text:unordered-list":
               self.inUnorderedList = 1
            elif name == "text:ordered-list":
               self.inOrderedList = 1
            elif name == "text:list-item":
               self.inListItem = 1
               self.currentListItemText = ""
               if self.inOrderedList:
                  self.orderedListCounter += 1
            elif name == "text:tab-stop":
               self.tabStop = 1
            elif name == "style:style":
                # TODO: What about the table-styles?
                self.inStyle = 1
                if attrs.get("style:family") == "paragraph":
                   self.inParagraphStyle = 1
                   self.currentStylename = attrs.get("style:name").encode("latin-1")
                if attrs.get("style:family") == "text":
                   self.inTextStyle = 1
                   self.currentStylename = attrs.get("style:name").encode("latin-1")
                if attrs.get("style:family") == "table":
                   tempname = attrs.get("style:name").encode("latin-1")
                   self.oo2pdf.doc.tablestyle_border[tempname] = 0
                   # table without border as default
                if attrs.get("style:family") == "table-column":
                     self.inTableColumnStyle = 1
                     self.currentTableColumnStyle = attrs.get("style:name").encode("latin-1")
                if attrs.get("style:family") == "table-cell":
                   self.inTableCellStyle = 1
                   self.currentTableStyle =  ((attrs.get("style:name"," . ")).encode("latin-1")).split(".")[0]
                   self.currentTableCellStyle = attrs.get("style:name").encode("latin-1")
                   #print "beginn: ",self.currentTableCellStyle
            elif name == "style:properties" and self.inStyle:
               if self.inParagraphStyle:
                  self.handleParagraphStyle(attrs)
               if self.inTextStyle:
                  self.handleTextStyle(attrs)
               if self.inTableCellStyle:
                  self.setTableBorder(attrs)
                  self.handleTableCellStyle(attrs)
               if self.inTableColumnStyle:
                    self.handleTableColumnStyle(attrs)
            elif name == "draw:image":
               self.currentPictureAttrs = attrs
               #self.emptyParagraph = 0
            else:
               # unrecognized events:
               # TODO - but it works better this way: 
               # self.inDropIt = 1
               self.inDropIt = 0
               # why not print everything?
               # TODO: cancel the following test:
               # self.currentParagraphText += ("<" + name + ">").encode("Latin-1")
        else:
            # print "exception"
            pass

    def handleParagraphStyle(self,attrs):
       styledict = self.oo2pdf.mapParagraphStyle(self.currentStylename,attrs)
       self.oo2pdf.addParagraphStyle(self.currentStylename,styledict)
       # TODO: this was switched of due to the use of initStyles()
       # but this was only experimental!

    def handleTableCellStyle(self,attrs):
       self.oo2pdf.addTableCellStyle(stylename=self.currentTableCellStyle,oo_attrs=attrs)

    def handleTableColumnStyle(self,attrs):
         self.oo2pdf.addTableColumnStyle(stylename=self.currentTableColumnStyle,oo_attrs=attrs)

    def handleTableColumn(self,attrs):
         self.oo2pdf.mapTableStyle(stylename=self.currentTableStyle,oo_attrs=attrs)

    def handleTableCell(self):
       row,column = self.tableRowCounter,self.tableColumnCounter
       #print "current-table-cell-style", self.currentTableCellStyle
       self.oo2pdf.updateTableStyle(table_stylename=self.currentTableStyle,cell_stylename=self.currentTableCellStyle,row=row,column=column)
         

    def handlePicture(self,attrs):
       try:
          filename = string.replace(attrs.get("xlink:href",""),"""#Pictures/""","")
       except:
          return 0
       content = self.readPicture(filename)
       self.pictureFiles[filename] = ""
       if self.inCell:
          if SKIP["images"]:
             self.currentCellContent.append(self.oo2pdf.addParagraph("""###pictures unprocessable###""","Heading1",return_not_add=1))
          else:
             self.currentCellContent.append(self.oo2pdf.addPicture(attrs,filename,content,return_not_add=1))
       else:
          if SKIP["images"]:
             self.oo2pdf.addParagraph("""###pictures unprocessable###""","Heading1")
          else:
             self.oo2pdf.addPicture(attrs,filename,content)
       return 1

    def handleTextStyle(self,attrs):
       self.oo2pdf.addTextStyle(self.currentStylename,attrs)

    def conditionalEscape(self,text):
       """Special escape for XML-Style-Markups in Platypus."""
       if self.inIntraParagraphMarkup:
          return self.oo2pdf.doc.textMarkupStyles.get(self.currentTextStyle,"""%s""") % escape(text)
       else:
          return escape(text)

    def endElement(self,name):
        """Custom-style endElement-Events. The events are used to build up the Platypus-"Story"."""
        # TODO: use try-except.
        if 1:
            ########## Handling the OO-Paragraphs (they are found almost everywhere in an OO-Document. ######## 
            if name == "text:h":
               name = "text:p"
            if name == "text:p":
                self.inParagraph = 0
                #if not self.inTable and not self.inOrderedList and not self.inUnorderedList: <= ??
                if not self.inOrderedList and not self.inUnorderedList:
                   # Normal paragraphs or paragraphs inside of tables:
                   if self.emptyParagraph:
                      if not self.inCell:
                         self.oo2pdf.addEmptyParagraph(self.currentParagraphStyle)
                      else:
                         if not self.imageAdded:
                            self.currentCellContent.append(self.oo2pdf.addEmptyParagraph(self.currentParagraphStyle,return_not_add=1))                         
                   else:
                      if not self.inCell:
                         self.oo2pdf.addParagraph(self.currentParagraphText,self.currentParagraphStyle)
                      else:
                         # you need a list of flowables (I don't no why), so you can't append only (' ').
                         self.currentCellContent.append(self.oo2pdf.addParagraph(self.currentParagraphText,self.currentParagraphStyle,return_not_add=1))
                elif self.inListItem:
                   # Paragraphs inside of lists.
                   if self.inOrderedList:
                      self.oo2pdf.addParagraph(self.currentListItemText,self.currentParagraphStyle,bullet="%s." % self.orderedListCounter,orderedList=1)
                   elif self.inUnorderedList:
                      self.oo2pdf.addParagraph(self.currentListItemText,self.currentParagraphStyle,bullet=".",orderedList=0)
                      
                                 
                #print "style-end: ",self.currentParagraphStyle,"\n"
                self.currentParagraphStyle = ""
                self.currentParagraphText = ""
                self.imageAdded = 0
                #if not self.inTable:
                #    self.text += "\n"
            elif name == "draw:image":
               # TODO: tables? or in handlePicture?
               self.imageAdded = self.handlePicture(self.currentPictureAttrs)
               self.currentPictureAttrs = {}
            elif name == "text:span":
               self.inIntraParagraphMarkup = 0
               self.currentTextStyle = ""
            elif name == "table:table":
                self.inTable = 0
                self.oo2pdf.addTable(self.currentTableContent,self.currentTableStyle)
                try:
                     del self.oo2pdf.doc.tablecolumn_widths[self.currentTableStyle]
                     # TODO: an ugly hack: so you can reuse table names that are
                     # used several times (happens when you use makeSerialLetters
                except:
                     pass
                self.currentTableStyle = ""
            elif name == "table:table-row":
                self.inRow = 0
                self.currentTableContent.append(self.currentRowContent)
                # print self.currentRowContent
            elif name == "table:table-cell":
                self.handleTableCell()
                # update the table_styles information
                if len(self.currentCellContent) > 1:
                   self.currentRowContent.append(self.currentCellContent)
                else:
                   self.currentRowContent.append(self.currentCellContent[0])
                   # Platypus cannot handle lists with a single element as table cell elements.
                self.inCell = 0
                self.currentTableCellStyle = ""
            elif name == "text:unordered-list":
               self.inUnorderedList = 0
               self.currentListItemText = ""
            elif name == "text:ordered-list":
               self.inOrderedList = 0
               self.orderedListCounter = 0
               self.currentListItemText = ""
            elif name == "text:list-item":
               self.inListItem = 0
               self.currentListItemText = ""
            elif name == "table:table-column":
                 self.inColumn = 0
                 self.currentTableColumnStyle = ""
            elif name == "table:table-header-rows":
                 self.inHeaderRows = 0
                 # TODO: to be implemented
            elif name == "style:style":
                self.inStyle = 0
                self.inParagraphStyle = 0
                self.inTextStyle = 0
                self.currentStylename = ""
                self.inTableCellStyle = 0
                self.inTableColumnStyle = 0
            else:
               self.inDropIt = 0
               # TODO: cancel the following test:
               # self.currentParagraphText += ("""</""" + name + ">").encode("Latin-1")
        else:
            pass

    def characters(self,characters):
       if self.inDropIt:
          return
       try:
          characters = characters.encode("cp1252","replace")  
          #characters = characters.encode("latin-1","replace")
       except:
          # skip "strange" unicode-characters etc.
          # TODO
          tempchar = ""
          for j in characters:
             try:
                tempchar += j.encode("cp1252")
             except:
                pass
          characters = tempchar
       tempTab = ""
       if self.tabStop:
          tempTab = self.oo2pdf.distancePoint(length=15)
          # TODO: very primitive and always white.
          self.tabStop = 0
       #if self.inIntraParagraphMarkup:
       #   characters = self.oo2pdf.doc.textMarkupStyles.get(self.currentTextStyle,"""%s""") % characters
       #characters = """%s<u>test</u>endetest""" % characters
       #characters = """<i>%s</i>""" % characters
       # TODO: handle tables properly o.k.?
       #if self.inParagraph and not self.inTable and not self.inOrderedList and not self.inUnorderedList:
       if self.inParagraph and not self.inOrderedList and not self.inUnorderedList:
          #self.text += characters
          self.currentParagraphText += tempTab + self.conditionalEscape(characters)
          #print self.currentParagraphStyle,": ",characters,"\n"
          self.emptyParagraph = 0
          return
       if self.inOrderedList and self.inListItem and self.inParagraph:
          #print "ordered-list: ",characters,"\n"
          self.currentListItemText += tempTab + self.conditionalEscape(characters)
          # print "Ordered style: ", self.currentParagraphStyle
          return
       if self.inUnorderedList and self.inListItem and self.inParagraph:
          #print "unordered-list"
          self.currentListItemText += tempTab + self.conditionalEscape(characters)
          return
       else:
          characters = string.strip(characters)
          # drop all spaces, returns etc. for sxw-files stored without "pretty-printing".
          if characters != "":
             self.oo2pdf.addParagraph(self.conditionalEscape(characters),"Normal")
          #print "Normal: ",characters
          return

class ooTextHandler(oo2pdfHandler):
     """Extract the plain text from a sxw-file. Inserts one carriage-return per sxw-paragraph."""
     def __init__(self,infile="test.sxw",outfile=None,plain_text_output=0):
          oo2pdfHandler.__init__(self,infile=infile,outfile=outfile)
          self.text = ""
          self.plain_text_output = plain_text_output # return as plain latin-1 text?

     def startElement(self,name,attrs):
          pass

     def endElement(self,name):
          if name == "text:p":
               self.text += "\n"

     def characters(self,characters):
          self.text += characters.encode("cp1252","replace")

     def makeParagraphs(self):
          list = self.text.split("\n")
          for l in list:
               self.oo2pdf.addParagraph(l,"Normal")

     def endDocument(self):
          if not self.plain_text_output:
               self.makeParagraphs()
          else:
               self.outfile = self.outfile[:-3] + "txt" # "txt" instead of "pdf"
               tempfile = open(self.outfile,"w")
               tempfile.write(string.strip(self.text))
               tempfile.close()

class persistentDict:
     """A helper class - the shelve module is not always reliable."""

     def __init__(self,dictfilename):
          self.dictfilename = dictfilename

     def getDict(self):
          try:
               file = open(self.dictfilename,"rb")
               dict = cPickle.load(file)
               file.close()
               return dict
          except:
               return {}

     def getValue(self,key):
          dict = self.getDict()
          return dict.get(key)

     def setValue(self,key,value):
          dict = self.getDict()
          file = open(self.dictfilename,"wb")
          dict[key] = value
          cPickle.dump(dict,file)
          file.close()

     def deleteValue(self,value):
          dict = self.getDict()
          try:
               del dict[value]
          except:
               pass
          file = open(self.dictfilename,"wb")
          cPickle.dump(dict,file)
          file.close()
               

class PyOpenOffice:
   """This is the main class which provides all functionality."""
   global VERBOSE

   def __init__(self,v=1):
      VERBOSE = v
      self.text_tool = textutilities_pyopenoffice.Textutilities()
      self.tempfiles = "PyOpenOffice_Tempfiles"
      self.pdict = persistentDict(self.tempfiles)
      dummydtd_name = os.path.join(os.getcwd(),"office.dtd") # required by the parsers
      dummy_dtd = open(dummydtd_name,"w")
      dummy_dtd.write("") # must be an empty file, otherwise the parser tries to parse it!
      dummy_dtd.close()

   def makePdf(self,infile="test.sxw",outfile=None,plainText=0,plain_text_output=0):
      # print "infile: ",infile
      if plainText:
           handler = ooTextHandler(infile,outfile,plain_text_output=plain_text_output)
      else:
           handler = oo2pdfHandler(infile,outfile)
      saxparser = xml.sax.make_parser()
      saxparser.setContentHandler(handler)
      # write two files into the current working directory for the parser:
      contentfile_name = os.path.join(os.getcwd(),"content.xml")
      contentfile = open(contentfile_name,"wb")
      # TODO: encoding here?
      content = handler.readContent()
      contentfile.write(content)
      contentfile.close()
      saxparser.parse(contentfile_name)
      #text = handler.text.encode("latin-1")
      # TODO: do not use hardcoded encoding
      if VERBOSE:
         print "parsing done!"
      if not plain_text_output:
           handler.oo2pdf.buildStory()
      try:
           os.remove(contentfile_name)
           os.remove(dummydtd_name) # house cleaning...
      except:
           pass # for problems with access rights
      for file in handler.pictureFiles.keys():
         try:
            os.remove(file)
         except:
            # file not found etc.
            pass
      # TODO: remove this test-tool:
      #os.remove(handler.oo2pdf.filename)
      # os.system("""acroread %s&""" % handler.oo2pdf.filename)
      return handler.outfile

   def makeSafePdf(self,oowriter,RML=0):
      """Make PDFs from a list of sxw-files or a single file. Make several trials, when an error occurs:
      full featured, without underlines, without images, text only without all formatting as a last rescue.
      With RML = 1 you convert RML files to PDF."""
      if type(oowriter) is not types.ListType and type(oowriter) is not types.TupleType:
           oowriter = ["%s" % oowriter] # only one file
      outfiles = []
      if RML:
           try:
                for i in oowriter:
                     temp = os.path.splitext(i)[0] + ".pdf"
                     outfiles.append(patched_trml2pdf.parseFile(file=i,fout=temp))
                     self._updateTempfiles(outfiles)
                return outfiles
           except:
                return outfiles
      for i in oowriter:
          try:
          #if 1:
             outfiles.append(self.makePdf(i))
          except:
          #else:
             #print "no underlines"
             SKIP["underline"] = 1
             try:
             #if 1:
                outfiles.append(self.makePdf(i))
             except:
             #else:
                #print "no images"
                SKIP["images"] = 1
                try:
                #if 1:
                     outfiles.append(self.makePdf(i))
                except:
                #else:
                     outfiles.append(self.makePlainText(i)[0])
          SKIP["underline"], SKIP["images"] = 0,0
      self._updateTempfiles(outfiles)
      return outfiles

   def makePlainText(self,oowriter,plain_text_output=0):
        """Makes PDFs or plain text files from sxw files. All XML-Tags for formatting are dropped,
        no images are processed, table cells are transformed to paragraphs with text data.
        Output: pdf or plain text (plain_text_output=1)."""
        outfiles = []
        if oowriter is not types.ListType or oowriter is not types.TupleType:
           oowriter = ["%s" % oowriter] # only one file
        for i in oowriter:
             outfiles.append(self.makePdf(infile=i,plainText=1,plain_text_output=plain_text_output))
        self._updateTempfiles(outfiles)
        return outfiles

   def unpackNormalize(self,sourcefile):
        """The OO archive is unpacked completely into the current directory.
        A "normalized" xml file is also generated. Use this for further processing
        with XSLT. Returns the name of the "normalized" file.
        Careful: after future changes in the XSLT stylesheets it may be necessary
        to update this function also."""
        update = []
        c = self.text_tool.openOfficeLesen(sourcefile)
        c = self.text_tool.openOfficeReplaceLinebreaks(c)
        s = self.text_tool.openOfficeLesen(sourcefile,archiv_datei="styles.xml")
        all = self.text_tool.openOfficeUnpackArchive(sourcefile)
        dom = textutilities_pyopenoffice.DomApi(c,s)
        dom.normalizeStyleProperties()
        # make absolute style properties from the style hierarchy
        dom.transferStylesXml()
        dom.normalizeLength()
        dom.normalizeTableColumns()
        new_c = dom.toxml()
        normalized = "normalized_" + os.path.splitext(sourcefile)[0] + ".xml"
        file = open(normalized,"wb")
        file.write(new_c)
        file.close()
        update = all + [normalized]
        self._updateTempfiles(update)
        return normalized
   
   def extractContentXml(self,sourcefile,RML=0):
        """Extract the content.xml from an SXW-Archive. Use this to work on it with your own customized functions,
        then pass the preprocessed content.xml to the variable "content" of makeSerialLetters().
        Always keep in mind that everything in content.xml has to be UTF-8-encoded. Do not use the RML switch: is used only
        for internal purposes."""
        return self.text_tool.openOfficeLesen(sourcefile,RML=RML)  

   def makeSerialLetters(self,sourcefile,replace_listofdicts,one_file=1,replace_fixeddict=textutilities_pyopenoffice.defaultkeywords,content="",data_with_linebreaks=0,transform_linebreaks=0,RML=0,with_multi=1):
      """Make Serial letters from the records in replace_listofdicts. If one_file=1, the output is merged to one file.
      Output: sxw. replace_fixeddict provides constants like for "TFA-today-TFE" and can be modified by the user.
      In "content" you can provide a preprocessed content.xml you extracted before from the sourcefile.
      If data_with_linebreaks=1, you carriage returns in the replace_listofdicts can be printed: This may be useful
      when processing databases containing values with carriage returns. All CR signs are recognized:
      \n,\r and \r\n and replaced by the open office tag <text:line-break/>.
      With transform_linebreaks=1, the open office tag <text:line-break/> is replaced by
      generating a new paragraph (necessary for PDF transformation of this tag).
      With RML = 1 you can process files in the Reportlab Markup Language."""
      if data_with_linebreaks:
           replace_listofdicts = self.text_tool.openOfficeDataWithLinebreaks(replace_listofdicts)
      if with_multi:
           newcontent = self.text_tool.openOfficeMultiReplace(sourcefile=sourcefile,replace_listofdicts=replace_listofdicts,as_file=0,content=content,RML=RML)
      else:
           newcontent = ""
      if RML:
           # with RML = 1 transforming linebreaks is mandatory -
           # otherwise the RML processor will be confused.
           # => there may be new linebreaks from the inserted data that have not been
           # already removed by unpackNormalize()!
           transform_linebreaks = 1
      temp = self.text_tool.openOfficeSerialLetter(sourcefile=sourcefile,replace_listofdicts=replace_listofdicts,one_file=one_file,content=newcontent,replace_fixeddict=replace_fixeddict,RML=RML,transform_linebreaks=transform_linebreaks)
      self._updateTempfiles(temp)
      return temp

   def transform_linebreaks(self,sourcefile,RML=0):
        """transform oo-linebreaks in an sxw-file or a RML file to a list of paragraphs (see above)."""
        text = self.extractContentXml(sourcefile,RML=RML)
        text = self.text_tool.openOfficeReplaceLinebreaks(text,RML=RML)
        self.text_tool.openOfficeErsetzen(datei=sourcefile,inhalt=text,RML=RML)

   def _updateTempfiles(self,value):
        if type(value) == types.ListType:
             for i in value:
                  if type(i) == types.StringType:
                       # first check the type! 
                       self.pdict.setValue(i,"dummy")
        elif type(value) == types.StringType:
             self.pdict.setValue(value,"dummy")

   def listTempfiles(self):
        temp = (self.pdict.getDict()).keys()
        return temp

   def cleanTempfiles(self):
        for f in self.listTempfiles():
             try:
                  os.remove(f)
                  self.pdict.deleteValue(f)
             except:
                  pass

   def replacePictures(self,sourcefile,pic_list,RML=0):
      if RML:
           dom = textutilities_pyopenoffice.DomApiGeneral(file=sourcefile,parse_all=1)
           temp = dom.replacePicturesRML(pic_list=pic_list)
      else:
           temp = self.text_tool.openOfficeReplacePictures(file=sourcefile,pic_list=pic_list)
      self._updateTempfiles(temp)
      return temp
      


extra = [{"Book": "Special", "Price": "100.00"}] * 50

lod = [{"Book": "Holy Bible, Luther Version", "Price": "15.00"},
       {"Book": "Calendar for Daily Devotion", "Price": "8.00"},
       {"Book": "Holy Bible, Good News Version", "Price": "17.00"},
       {"Surname": "\nSimon(with linebreak)", "FirstName": "Martin"},
       {"Surname": "Miller","FirstName": "Steve"},
       {"Surname": "Smith", "FirstName": "John"},
       {"StrangeField": "StrangeValue"}]
# Uncomment to view long tables using more than one page:
# lod += extra


pictest = [{"Headline": "Useful Bible Study","Pic1": "Pray","Pic2": "Read","Pic3": "Think","Pic4": "Pray again","Pic5": "Practice it!","Pic6": "You see: The place is left empty."}]

piclist = ["pray1.pcx","read.pcx","think.pcx","pray2.pcx","act.pcx"]          
          
         
 
if __name__ == "__main__":
   # TODO: remove test
   try:
      infile = [sys.argv[1]]
   except:
      infile = ["test.sxw"]
   tool = PyOpenOffice()
   newfile = ""
   if infile[0] == "-pictest": 
        newfile = tool.replacePictures("test_pic.sxw",piclist)
        #newfile = "test_pic.sxw"
        newfile = tool.makeSerialLetters(newfile,pictest)
        #print newfile
   elif infile[0] == "-cleanup":
        print "Tempfiles generated since last cleanup:"
        for i in tool.listTempfiles():
             print i
        tool.cleanTempfiles()
        print "\nTempfiles left after cleanup:"
        for i in tool.listTempfiles():
             print i
        sys.exit()
   else:
        newfile = tool.makeSerialLetters(sourcefile=infile[0],replace_listofdicts=lod,data_with_linebreaks=1,transform_linebreaks=1)
   print "Output PDF: ",tool.makeSafePdf(newfile)
