#coding: latin-1

# PyOpenOffice Version 0.4
# Copyright (C) 2005: Martin Simon
# Homepage: www.bezirksreiter.de

# PyOpenOffice Version 0.4
# Copyright (C) 2005: Martin Simon
# Homepage: www.bezirksreiter.de

## GNU LESSER GENERAL PUBLIC LICENSE
##		       Version 2.1, February 1999

## Copyright (C) 1991, 1999 Free Software Foundation, Inc.
##     51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
## Everyone is permitted to copy and distribute verbatim copies
## of this license document, but changing it is not allowed.

##[This is the first released version of the Lesser GPL.  It also counts
## as the successor of the GNU Library Public License, version 2, hence
## the version number 2.1.]

##			    Preamble

##  The licenses for most software are designed to take away your
##freedom to share and change it.  By contrast, the GNU General Public
##Licenses are intended to guarantee your freedom to share and change
##free software--to make sure the software is free for all its users.

##  This license, the Lesser General Public License, applies to some
##specially designated software packages--typically libraries--of the
##Free Software Foundation and other authors who decide to use it.  You
##can use it too, but we suggest you first think carefully about whether
##this license or the ordinary General Public License is the better
##strategy to use in any particular case, based on the explanations below.

##  When we speak of free software, we are referring to freedom of use,
##not price.  Our General Public Licenses are designed to make sure that
##you have the freedom to distribute copies of free software (and charge
##for this service if you wish); that you receive source code or can get
##it if you want it; that you can change the software and use pieces of
##it in new free programs; and that you are informed that you can do
##these things.

##  To protect your rights, we need to make restrictions that forbid
##distributors to deny you these rights or to ask you to surrender these
##rights.  These restrictions translate to certain responsibilities for
##you if you distribute copies of the library or if you modify it.

##  For example, if you distribute copies of the library, whether gratis
##or for a fee, you must give the recipients all the rights that we gave
##you.  You must make sure that they, too, receive or can get the source
##code.  If you link other code with the library, you must provide
##complete object files to the recipients, so that they can relink them
##with the library after making changes to the library and recompiling
##it.  And you must show them these terms so they know their rights.

##  We protect your rights with a two-step method: (1) we copyright the
##library, and (2) we offer you this license, which gives you legal
##permission to copy, distribute and/or modify the library.

##  To protect each distributor, we want to make it very clear that
##there is no warranty for the free library.  Also, if the library is
##modified by someone else and passed on, the recipients should know
##that what they have is not the original version, so that the original
##author's reputation will not be affected by problems that might be
##introduced by others.

##  Finally, software patents pose a constant threat to the existence of
##any free program.  We wish to make sure that a company cannot
##effectively restrict the users of a free program by obtaining a
##restrictive license from a patent holder.  Therefore, we insist that
##any patent license obtained for a version of the library must be
##consistent with the full freedom of use specified in this license.

##  Most GNU software, including some libraries, is covered by the
##ordinary GNU General Public License.  This license, the GNU Lesser
##General Public License, applies to certain designated libraries, and
##is quite different from the ordinary General Public License.  We use
##this license for certain libraries in order to permit linking those
##libraries into non-free programs.

##  When a program is linked with a library, whether statically or using
##a shared library, the combination of the two is legally speaking a
##combined work, a derivative of the original library.  The ordinary
##General Public License therefore permits such linking only if the
##entire combination fits its criteria of freedom.  The Lesser General
##Public License permits more lax criteria for linking other code with
##the library.

##  We call this license the "Lesser" General Public License because it
##does Less to protect the user's freedom than the ordinary General
##Public License.  It also provides other free software developers Less
##of an advantage over competing non-free programs.  These disadvantages
##are the reason we use the ordinary General Public License for many
##libraries.  However, the Lesser license provides advantages in certain
##special circumstances.

##  For example, on rare occasions, there may be a special need to
##encourage the widest possible use of a certain library, so that it becomes
##a de-facto standard.  To achieve this, non-free programs must be
##allowed to use the library.  A more frequent case is that a free
##library does the same job as widely used non-free libraries.  In this
##case, there is little to gain by limiting the free library to free
##software only, so we use the Lesser General Public License.

##  In other cases, permission to use a particular library in non-free
##programs enables a greater number of people to use a large body of
##free software.  For example, permission to use the GNU C Library in
##non-free programs enables many more people to use the whole GNU
##operating system, as well as its variant, the GNU/Linux operating
##system.

##  Although the Lesser General Public License is Less protective of the
##users' freedom, it does ensure that the user of a program that is
##linked with the Library has the freedom and the wherewithal to run
##that program using a modified version of the Library.

##  The precise terms and conditions for copying, distribution and
##modification follow.  Pay close attention to the difference between a
##"work based on the library" and a "work that uses the library".  The
##former contains code derived from the library, whereas the latter must
##be combined with the library in order to run.

##		  GNU LESSER GENERAL PUBLIC LICENSE
##   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

##  0. This License Agreement applies to any software library or other
##program which contains a notice placed by the copyright holder or
##other authorized party saying it may be distributed under the terms of
##this Lesser General Public License (also called "this License").
##Each licensee is addressed as "you".

##  A "library" means a collection of software functions and/or data
##prepared so as to be conveniently linked with application programs
##(which use some of those functions and data) to form executables.

##  The "Library", below, refers to any such software library or work
##which has been distributed under these terms.  A "work based on the
##Library" means either the Library or any derivative work under
##copyright law: that is to say, a work containing the Library or a
##portion of it, either verbatim or with modifications and/or translated
##straightforwardly into another language.  (Hereinafter, translation is
##included without limitation in the term "modification".)

##  "Source code" for a work means the preferred form of the work for
##making modifications to it.  For a library, complete source code means
##all the source code for all modules it contains, plus any associated
##interface definition files, plus the scripts used to control compilation
##and installation of the library.

##  Activities other than copying, distribution and modification are not
##covered by this License; they are outside its scope.  The act of
##running a program using the Library is not restricted, and output from
##such a program is covered only if its contents constitute a work based
##on the Library (independent of the use of the Library in a tool for
##writing it).  Whether that is true depends on what the Library does
##and what the program that uses the Library does.
  
##  1. You may copy and distribute verbatim copies of the Library's
##complete source code as you receive it, in any medium, provided that
##you conspicuously and appropriately publish on each copy an
##appropriate copyright notice and disclaimer of warranty; keep intact
##all the notices that refer to this License and to the absence of any
##warranty; and distribute a copy of this License along with the
##Library.

##  You may charge a fee for the physical act of transferring a copy,
##and you may at your option offer warranty protection in exchange for a
##fee.

##  2. You may modify your copy or copies of the Library or any portion
##of it, thus forming a work based on the Library, and copy and
##distribute such modifications or work under the terms of Section 1
##above, provided that you also meet all of these conditions:

##    a) The modified work must itself be a software library.

##    b) You must cause the files modified to carry prominent notices
##    stating that you changed the files and the date of any change.

##    c) You must cause the whole of the work to be licensed at no
##    charge to all third parties under the terms of this License.

##    d) If a facility in the modified Library refers to a function or a
##    table of data to be supplied by an application program that uses
##    the facility, other than as an argument passed when the facility
##    is invoked, then you must make a good faith effort to ensure that,
##    in the event an application does not supply such function or
##    table, the facility still operates, and performs whatever part of
##    its purpose remains meaningful.

##    (For example, a function in a library to compute square roots has
##    a purpose that is entirely well-defined independent of the
##    application.  Therefore, Subsection 2d requires that any
##    application-supplied function or table used by this function must
##    be optional: if the application does not supply it, the square
##    root function must still compute square roots.)

##These requirements apply to the modified work as a whole.  If
##identifiable sections of that work are not derived from the Library,
##and can be reasonably considered independent and separate works in
##themselves, then this License, and its terms, do not apply to those
##sections when you distribute them as separate works.  But when you
##distribute the same sections as part of a whole which is a work based
##on the Library, the distribution of the whole must be on the terms of
##this License, whose permissions for other licensees extend to the
##entire whole, and thus to each and every part regardless of who wrote
##it.

##Thus, it is not the intent of this section to claim rights or contest
##your rights to work written entirely by you; rather, the intent is to
##exercise the right to control the distribution of derivative or
##collective works based on the Library.

##In addition, mere aggregation of another work not based on the Library
##with the Library (or with a work based on the Library) on a volume of
##a storage or distribution medium does not bring the other work under
##the scope of this License.

##  3. You may opt to apply the terms of the ordinary GNU General Public
##License instead of this License to a given copy of the Library.  To do
##this, you must alter all the notices that refer to this License, so
##that they refer to the ordinary GNU General Public License, version 2,
##instead of to this License.  (If a newer version than version 2 of the
##ordinary GNU General Public License has appeared, then you can specify
##that version instead if you wish.)  Do not make any other change in
##these notices.

##  Once this change is made in a given copy, it is irreversible for
##that copy, so the ordinary GNU General Public License applies to all
##subsequent copies and derivative works made from that copy.

##  This option is useful when you wish to copy part of the code of
##the Library into a program that is not a library.

##  4. You may copy and distribute the Library (or a portion or
##derivative of it, under Section 2) in object code or executable form
##under the terms of Sections 1 and 2 above provided that you accompany
##it with the complete corresponding machine-readable source code, which
##must be distributed under the terms of Sections 1 and 2 above on a
##medium customarily used for software interchange.

##  If distribution of object code is made by offering access to copy
##from a designated place, then offering equivalent access to copy the
##source code from the same place satisfies the requirement to
##distribute the source code, even though third parties are not
##compelled to copy the source along with the object code.

##  5. A program that contains no derivative of any portion of the
##Library, but is designed to work with the Library by being compiled or
##linked with it, is called a "work that uses the Library".  Such a
##work, in isolation, is not a derivative work of the Library, and
##therefore falls outside the scope of this License.

##  However, linking a "work that uses the Library" with the Library
##creates an executable that is a derivative of the Library (because it
##contains portions of the Library), rather than a "work that uses the
##library".  The executable is therefore covered by this License.
##Section 6 states terms for distribution of such executables.

##  When a "work that uses the Library" uses material from a header file
##that is part of the Library, the object code for the work may be a
##derivative work of the Library even though the source code is not.
##Whether this is true is especially significant if the work can be
##linked without the Library, or if the work is itself a library.  The
##threshold for this to be true is not precisely defined by law.

##  If such an object file uses only numerical parameters, data
##structure layouts and accessors, and small macros and small inline
##functions (ten lines or less in length), then the use of the object
##file is unrestricted, regardless of whether it is legally a derivative
##work.  (Executables containing this object code plus portions of the
##Library will still fall under Section 6.)

##  Otherwise, if the work is a derivative of the Library, you may
##distribute the object code for the work under the terms of Section 6.
##Any executables containing that work also fall under Section 6,
##whether or not they are linked directly with the Library itself.

##  6. As an exception to the Sections above, you may also combine or
##link a "work that uses the Library" with the Library to produce a
##work containing portions of the Library, and distribute that work
##under terms of your choice, provided that the terms permit
##modification of the work for the customer's own use and reverse
##engineering for debugging such modifications.

##  You must give prominent notice with each copy of the work that the
##Library is used in it and that the Library and its use are covered by
##this License.  You must supply a copy of this License.  If the work
##during execution displays copyright notices, you must include the
##copyright notice for the Library among them, as well as a reference
##directing the user to the copy of this License.  Also, you must do one
##of these things:

##    a) Accompany the work with the complete corresponding
##    machine-readable source code for the Library including whatever
##    changes were used in the work (which must be distributed under
##    Sections 1 and 2 above); and, if the work is an executable linked
##    with the Library, with the complete machine-readable "work that
##    uses the Library", as object code and/or source code, so that the
##    user can modify the Library and then relink to produce a modified
##    executable containing the modified Library.  (It is understood
##    that the user who changes the contents of definitions files in the
##    Library will not necessarily be able to recompile the application
##    to use the modified definitions.)

##    b) Use a suitable shared library mechanism for linking with the
##    Library.  A suitable mechanism is one that (1) uses at run time a
##    copy of the library already present on the user's computer system,
##    rather than copying library functions into the executable, and (2)
##    will operate properly with a modified version of the library, if
##    the user installs one, as long as the modified version is
##    interface-compatible with the version that the work was made with.

##    c) Accompany the work with a written offer, valid for at
##    least three years, to give the same user the materials
##    specified in Subsection 6a, above, for a charge no more
##    than the cost of performing this distribution.

##    d) If distribution of the work is made by offering access to copy
##    from a designated place, offer equivalent access to copy the above
##    specified materials from the same place.

##    e) Verify that the user has already received a copy of these
##    materials or that you have already sent this user a copy.

##  For an executable, the required form of the "work that uses the
##Library" must include any data and utility programs needed for
##reproducing the executable from it.  However, as a special exception,
##the materials to be distributed need not include anything that is
##normally distributed (in either source or binary form) with the major
##components (compiler, kernel, and so on) of the operating system on
##which the executable runs, unless that component itself accompanies
##the executable.

##  It may happen that this requirement contradicts the license
##restrictions of other proprietary libraries that do not normally
##accompany the operating system.  Such a contradiction means you cannot
##use both them and the Library together in an executable that you
##distribute.

##  7. You may place library facilities that are a work based on the
##Library side-by-side in a single library together with other library
##facilities not covered by this License, and distribute such a combined
##library, provided that the separate distribution of the work based on
##the Library and of the other library facilities is otherwise
##permitted, and provided that you do these two things:

##    a) Accompany the combined library with a copy of the same work
##    based on the Library, uncombined with any other library
##    facilities.  This must be distributed under the terms of the
##    Sections above.

##    b) Give prominent notice with the combined library of the fact
##    that part of it is a work based on the Library, and explaining
##    where to find the accompanying uncombined form of the same work.

##  8. You may not copy, modify, sublicense, link with, or distribute
##the Library except as expressly provided under this License.  Any
##attempt otherwise to copy, modify, sublicense, link with, or
##distribute the Library is void, and will automatically terminate your
##rights under this License.  However, parties who have received copies,
##or rights, from you under this License will not have their licenses
##terminated so long as such parties remain in full compliance.

##  9. You are not required to accept this License, since you have not
##signed it.  However, nothing else grants you permission to modify or
##distribute the Library or its derivative works.  These actions are
##prohibited by law if you do not accept this License.  Therefore, by
##modifying or distributing the Library (or any work based on the
##Library), you indicate your acceptance of this License to do so, and
##all its terms and conditions for copying, distributing or modifying
##the Library or works based on it.

##  10. Each time you redistribute the Library (or any work based on the
##Library), the recipient automatically receives a license from the
##original licensor to copy, distribute, link with or modify the Library
##subject to these terms and conditions.  You may not impose any further
##restrictions on the recipients' exercise of the rights granted herein.
##You are not responsible for enforcing compliance by third parties with
##this License.

##  11. If, as a consequence of a court judgment or allegation of patent
##infringement or for any other reason (not limited to patent issues),
##conditions are imposed on you (whether by court order, agreement or
##otherwise) that contradict the conditions of this License, they do not
##excuse you from the conditions of this License.  If you cannot
##distribute so as to satisfy simultaneously your obligations under this
##License and any other pertinent obligations, then as a consequence you
##may not distribute the Library at all.  For example, if a patent
##license would not permit royalty-free redistribution of the Library by
##all those who receive copies directly or indirectly through you, then
##the only way you could satisfy both it and this License would be to
##refrain entirely from distribution of the Library.

##If any portion of this section is held invalid or unenforceable under any
##particular circumstance, the balance of the section is intended to apply,
##and the section as a whole is intended to apply in other circumstances.

##It is not the purpose of this section to induce you to infringe any
##patents or other property right claims or to contest validity of any
##such claims; this section has the sole purpose of protecting the
##integrity of the free software distribution system which is
##implemented by public license practices.  Many people have made
##generous contributions to the wide range of software distributed
##through that system in reliance on consistent application of that
##system; it is up to the author/donor to decide if he or she is willing
##to distribute software through any other system and a licensee cannot
##impose that choice.

##This section is intended to make thoroughly clear what is believed to
##be a consequence of the rest of this License.

##  12. If the distribution and/or use of the Library is restricted in
##certain countries either by patents or by copyrighted interfaces, the
##original copyright holder who places the Library under this License may add
##an explicit geographical distribution limitation excluding those countries,
##so that distribution is permitted only in or among countries not thus
##excluded.  In such case, this License incorporates the limitation as if
##written in the body of this License.

##  13. The Free Software Foundation may publish revised and/or new
##versions of the Lesser General Public License from time to time.
##Such new versions will be similar in spirit to the present version,
##but may differ in detail to address new problems or concerns.

##Each version is given a distinguishing version number.  If the Library
##specifies a version number of this License which applies to it and
##"any later version", you have the option of following the terms and
##conditions either of that version or of any later version published by
##the Free Software Foundation.  If the Library does not specify a
##license version number, you may choose any version ever published by
##the Free Software Foundation.

##  14. If you wish to incorporate parts of the Library into other free
##programs whose distribution conditions are incompatible with these,
##write to the author to ask for permission.  For software which is
##copyrighted by the Free Software Foundation, write to the Free
##Software Foundation; we sometimes make exceptions for this.  Our
##decision will be guided by the two goals of preserving the free status
##of all derivatives of our free software and of promoting the sharing
##and reuse of software generally.

##			    NO WARRANTY

##  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO
##WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.
##EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
##OTHER PARTIES PROVIDE THE LIBRARY "AS IS" WITHOUT WARRANTY OF ANY
##KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
##IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
##PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
##LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME
##THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

##  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
##WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
##AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU
##FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR
##CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
##LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
##RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
##FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
##SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
##DAMAGES.

##		     END OF TERMS AND CONDITIONS

##           How to Apply These Terms to Your New Libraries

##  If you develop a new library, and you want it to be of the greatest
##possible use to the public, we recommend making it free software that
##everyone can redistribute and change.  You can do so by permitting
##redistribution under these terms (or, alternatively, under the terms of the
##ordinary General Public License).

##  To apply these terms, attach the following notices to the library.  It is
##safest to attach them to the start of each source file to most effectively
##convey the exclusion of warranty; and each file should have at least the
##"copyright" line and a pointer to where the full notice is found.

##    <one line to give the library's name and a brief idea of what it does.>
##    Copyright (C) <year>  <name of author>

##    This library is free software; you can redistribute it and/or
##    modify it under the terms of the GNU Lesser General Public
##    License as published by the Free Software Foundation; either
##    version 2.1 of the License, or (at your option) any later version.

##    This library is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
##    Lesser General Public License for more details.

##    You should have received a copy of the GNU Lesser General Public
##    License along with this library; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

##Also add information on how to contact you by electronic and paper mail.

##You should also get your employer (if you work as a programmer) or your
##school, if any, to sign a "copyright disclaimer" for the library, if
##necessary.  Here is a sample; alter the names:

##  Yoyodyne, Inc., hereby disclaims all copyright interest in the
##  library `Frob' (a library for tweaking knobs) written by James Random Hacker.

##  <signature of Ty Coon>, 1 April 1990
##  Ty Coon, President of Vice

##That's all there is to it!

import sys
import re
import string
import types
import os
import glob
import shutil
import time
import copy
import xml.sax
import xml.sax.handler
from xml.sax.saxutils import escape
import zipfile
import shelve
import xml.dom.minidom

from reportlab.lib.units import toLength

try:
     # Imports for the "Bezirkreiter"-Software
     import normalDate
     import datumutilities
     import verschiedeneUtilities
     import sortieren
except:
     pass


VERBOSE = 0
# fixed keywords for the makeSerialLetter() function of PyOpenOffice:
defaultkeywords = {"heute": time.strftime('%d.%m.%Y', time.localtime(time.time())),
                   "today": time.strftime('%d/%m/%Y', time.localtime(time.time()))}
# be careful with the globals when deriving classes!

def plattformTesten():
    """Tests the current platform: win95, winNT, other.""" 
    win = 0
    win_nt = 0
    try:
        if sys.platform[:3] == "win":
            win = 1
            try:
                if (os.environ["OS"].lower()).find("nt") != -1 and win:
                    # os.environ["OS"] nicht unter Linux und Win95!
                    win_nt = 1
            except:
                pass
    except:
        pass
    return win, win_nt

class Regexes:
     def __init__(self):
        self.datumsform = re.compile(r"((\d?\d)\.\s?(\d?\d)\.\s?(\d\d\d\d))")
        self.datumstext = re.compile(r"((\d?\d)\.\s?(Januar|Februar|März|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember)\s?(\d\d\d\d))")
        self.monate = {"Januar":"01", "Februar":"02", "März":"03", "April":"04","Mai":"05","Juni":"06","Juli":"07","August":"08","September":"09","Oktober":"10","November":"11","Dezember":"12"}


## Textutilities: An utility-class for different text operations.
## I wrote this module originally for a church administration software ("Bezirksreiter" => www.bezirksreiter.de)
## This software was written for German language users, so unfortunately many comments and names in "Textutilities" are in German - sorry.
## I hope I can fix this one day...

class DomApiGeneral:
     """General DOM API utilities."""
     def __init__(self,content_string="",file="",parse_all=0):
	  #self.re_digits = re.compile(r"(\d?\d?\d?\d?\d?\d?)(pt|cm|mm|inch)")
          self.content_string = content_string
          self.file = file
	  self.re_digits = re.compile(r"(.*?\d)(pt|cm|mm|inch|in)")
          # improved regex, number of digits not limited
	  # self.re_digits = re.compile(r"(\d)(pt|cm|mm|inch)")
          if file:
               try:
                    f = open(file,"rb")
                    self.content_string = f.read()
                    f.close()
               except:
                    print "Unable to open file %s!" % file
          self.text_tool = Textutilities()
          if self.content_string != "" and parse_all:
               self.dom_api = xml.dom.minidom.parseString(self.content_string)
          else:
               pass # you may pass it in subclasses

     def replacePicturesRML(self,pic_list):
          """Same like openOfficeReplacePictures in the Textutilities class, but for RML files."""
          all = self.dom_api.getElementsByTagName("image")
          if not all or (pic_list == []):
               return self.file
          import Image
          for index in range(len(all)):
               pic = all[index]
               if index > len(pic_list)-1:
                    parent = pic.parentNode
                    parent.removeChild(pic)
                    continue
               im = Image.open(pic_list[index])
               proportion = float(im.size[1]) / float(im.size[0])
               height_tuple = self._unitTuple(pic.getAttribute("height"))
               width_tuple = self._unitTuple(pic.getAttribute("width"))
               new_height = float(width_tuple[0]) * proportion
               pic.setAttribute("height","%s%s" % (new_height,height_tuple[1]))
               pic.setAttribute("file",pic_list[index])
               if pic.parentNode.nodeName == "illustration":
                    pic.parentNode.setAttribute("height","%s%s" % (new_height,height_tuple[1]))
                    # adapt the illustration surrounding the picture
          new_file = "NewPics_" + self.file
          self.text_tool.openOfficeErsetzen(datei=self.file,inhalt=self.toxml(),neuedatei=new_file,RML=1)
          return new_file

     def _unitTuple(self,string):
          """Split values and units to a tuple."""
          temp = self.re_digits.findall(string)
          if not temp:
               return (string,"")
          else:
               return (temp[0])

     def restoreContentString(self):
          """Write self.content_string to self.file.
          This does not use the DOM-API and toxml()! =>
          Sometimes you use unparsed XML for faster processing."""
          try:
               temp = open(self.file,"wb")
               temp.write(self.content_string)
               temp.close()
          except:
               pass

     def toxml(self):
          return self.dom_api.toxml(encoding="utf-8")

     def stringPercentToFloat(self,string):
          temp = string.replace("""%""","")
	  return float(temp)/100

     def parseSubsection(self,starttag,endtag,content,with_dom=1,mitTags="ja"):
          """Extract a section from an XML stylesheet defined by
          two regexes an make a dom api for it."""
          sub = self.text_tool.extract_tags_all(starttag=starttag,endtag=endtag,inhalt=content,mitTags=mitTags)[0]
          # we need both the DOM-API and the original text for later replacement
          if with_dom:
               return xml.dom.minidom.parseString(sub),sub
          else:
               return sub

     def parseStylesheetRML(self,content,with_dom=1,mitTags="ja"):
          """Extract the stylesheet section from an RML text
          and make a dom api for it."""
          stylesheet_left = re.compile(r"<stylesheet.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
          stylesheet_right = re.compile(r"</stylesheet>",re.DOTALL | re.IGNORECASE | re.UNICODE)
          return self.parseSubsection(starttag=stylesheet_left,endtag=stylesheet_right,content=content,with_dom=with_dom,mitTags="ja")     
  
     def findBlockTableStyleRML(self,id):
          """Extract the stylesheet section from an RML text
          and make a dom api for it."""
          block_left = re.compile(r"<blockTableStyle.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
          block_right = re.compile(r"</blockTableStyle>",re.DOTALL | re.IGNORECASE | re.UNICODE)
          id = re.compile(r"id=\"%s\"" % id,re.DOTALL | re.IGNORECASE | re.UNICODE)
          all = self.text_tool.extract_tags_all(starttag=block_left,endtag=block_right,inhalt=self.content_string)
          for a in all:
               if id.search(a):
                    # return the first match only
                    return a
          return None

     def findChildrenByName(self,parent,name,attr_dict={}):
          """Helper functions. Does not work recursively.
          Optional: also test for certain attribute/value pairs."""
          children = []
          for c in parent.childNodes:
               if c.nodeType == c.ELEMENT_NODE and c.nodeName == name:
                    children.append(c)
          if attr_dict == {}:
               return children
          else:
               return self._selectForAttributes(nodelist=children,attr_dict=attr_dict)

     def _selectForAttributes(self,nodelist,attr_dict):
          "Helper function."""
          selected_nodes = []
          for n in nodelist:
               check = 1
               for a in attr_dict.keys():
                    if n.getAttribute(a) != attr_dict[a]:
                         # at least one incorrect attribute value?
                         check = 0
               if check:
                    selected_nodes.append(n)
          return selected_nodes
     
     def adaptBlockTableStyle_New(self,style,row,offset):
          """A specialized function for RML processing when dealing
          with Multi:TFA-...-TFE tags: Adapt the cell background, grid, etc.
          When using paragraphs inside of tables this will be - for example -
          the only way to get cell background colour allright."""
          style_dict = {"id": style}
          sub = self.findBlockTableStyleRML(id=style)
          old_sub = copy.copy(sub)
          start_stop = re.compile(r"(<.*?start=\"(.*?)\".*?stop=\"(.*?)\".*?/>)",re.DOTALL | re.IGNORECASE | re.UNICODE)
          all = start_stop.findall(sub)
          for a in all:
               start = self._stringToTuple(a[1])
               stop = self._stringToTuple(a[2])
               if start[1] == row:
                    temp_a=a[0].replace("stop=\"%s\""% a[2],"stop=\"%s\"" % self._tupleToString((stop[0],stop[1]+offset)))
                    sub = sub.replace(a[0],temp_a)
               elif start[1] > row:
                    # the following will not work => use the DOM-Api instead
                    temp_b=a[0].replace("start=\"%s\""% a[1],"start=\"%s\"" % self._tupleToString((start[0],start[1]+offset)))
                    temp_b=temp_b.replace("stop=\"%s\""% a[2],"stop=\"%s\"" % self._tupleToString((stop[0],stop[1]+offset)))
                    sub = sub.replace(a[0],temp_b)
                    print "########### new sub ###############"
                    print sub
                    #print a[0]
                    #print temp_b
                    #print "#########"
                    #del temp_b
          print sub
         # print "##########"
          #print old_sub
     

     def adaptBlockTableStyle(self,style,row,offset):
          """A specialized function for RML processing when dealing
          with Multi:TFA-...-TFE tags: Adapt the cell background, grid, etc.
          When using paragraphs inside of tables this will be - for example -
          the only way to get cell background colour allright."""
          style_dict = {"id": style}
          sub_dom,old_sub = self.parseStylesheetRML(content=self.content_string)
          # you need the original, unprocessed text you find in old_sub - otherwise
          # the replacement operation (see below) will not work.
          root = sub_dom.getElementsByTagName("stylesheet")[0]
          try:
               table = self.findChildrenByName(parent=root,name="blockTableStyle",attr_dict=style_dict)[0]
          except:
               return
          all = self.findChildrenByNodeType(parent=table,nodeType=root.ELEMENT_NODE)
          for a in all:
               start = self._stringToTuple(s=a.getAttribute("start"))
               stop = self._stringToTuple(s=a.getAttribute("stop"))
               if start and start[1] == row:
                    a.setAttribute("stop",self._tupleToString((stop[0], stop[1] + offset)))
               elif start and start[1] > row:
                    a.setAttribute("start",self._tupleToString((start[0], start[1] + offset)))
                    a.setAttribute("stop",self._tupleToString((stop[0], stop[1] + offset)))
          new_sub = self.parseStylesheetRML(content=sub_dom.toxml(),with_dom=0,mitTags="nein")
          # mind the transformation of new_sub: some XSLT processor have Utf8 output by default.
          self.content_string = self.content_string.replace(old_sub,self.openOfficeStringUtf8(new_sub))
          self.restoreContentString()
          # restore will be done only when you use this function for a file

     def _stringToTuple(self,s):
          """Helper function."""
          try:
               temp = string.split(s,",")
               return int(temp[0]),int(temp[1])
          except:
               return None

     def _tupleToString(self,t):
          try:
               return self.openOfficeStringUtf8("%s,%s" % (t[0],t[1]))
          except:
               return None

     def _lengthToFloat(self,value):
          v = value
          if not self.re_digits.search(v):
               # only number + pt|mm|cm|inch are converted
               return v
          try:
               if v[-4:] == "inch":
                    # OO files use "inch" instead of "in" in Reportlab units
                    v = v[:-2]
          except:
               pass
          try:
               c = round(toLength(v))
               # round it, otherwise you get fonts with 11.00001 pt etc...
               return c
          except:
               return v

     def deleteChildrenByName(self,parent,name):
          for child in parent.childNodes:
               if child.nodeType == child.ELEMENT_NODE and child.nodeName == name:
                    parent.removeChild(child)
               self.deleteChildrenByName(child,name)

     def _findChildrenByNodeType(self,parent,nodeType):
	 """Find all children of the given parent that are of
	 the given nodeType recursively."""
	 for child in parent.childNodes:
	     if child.nodeType == nodeType:
		 self.templist.append(child)
	     self._findChildrenByNodeType(child,nodeType)

     def findChildrenByNodeType(self,parent,nodeType):
	 # !!! wrapper function for the recursive function necessary
	 # => you have to have a class variable (self.templist) to collect the hits.
	 # TODO: not error-safe yet
	 self.templist = []
	 try:
	     self._findChildrenByNodeType(parent,nodeType)
             return self.templist
	 except:
	     return templist

     def insertListOfNodesAfter(self,refnode,list_of_nodes):
	 count = range(len(list_of_nodes)-1,-1,-1)
	 parent = refnode.parentNode
	 for c in count:
	     insert = list_of_nodes[c]
	     refnode = parent.insertBefore(insert,refnode)
	     # this is the first node of list_of_nodes
	 return refnode

     def openOfficeStringUtf8(self,string):
         if type(string) == unicode:
              # for Asian fonts etc.:
              return string.encode("utf-8")
         tempstring = unicode(string,"cp1252").encode("utf-8")
         return tempstring 
	     

class DomApi(DomApiGeneral):
     """This class provides a DOM-API for XML-Files from an SXW-Archive."""
     # TODO: really use latin-1 for tag names?
     
     def __init__(self,xml_content,xml_styles):
          DomApiGeneral.__init__(self)
          self.content_dom = xml.dom.minidom.parseString(xml_content)
	  self.styles_dom = xml.dom.minidom.parseString(xml_styles)
	  self.body = None
	  try:
	      self.body = self.content_dom.getElementsByTagName("office:body")[0]
	  except:
	      pass # for styles.xml etc.
          # temp_aut = self.content_dom.getElementsByTagName("office:automatic-styles")[0]
	  # TODO: 
          self.style_dict = {}
	  self.style_hierarchy_dict = {}
	  self.style_properties_dict = {}
	  self.style_properties_hierarchical = {}
         ## self.automatic_styles = temp_aut.childNodes
##          self.page_master = None
##	  self.clipboard = None
##          for s in self.automatic_styles:
##               if s.nodeType == s.ELEMENT_NODE:
##                    name = s.getAttribute("style:name").encode("latin-1")
##                    self.style_dict[name] = s
##                    if s.nodeName == "style:page-master":
##                         self.page_master = s
	  # TODO: new style-routine o.k.?
	  # ******** always use the following order:
	  self.buildStyleDict()
	  self.buildStyleHierarchyDict()
	  self.buildStylePropertiesDict()
	  self.buildStylePropertiesHierarchical()
	  self.page_master = self.styles_dom.getElementsByTagName("style:page-master")[0]
          self.document = self.content_dom.getElementsByTagName("office:document-content")[0]

     def buildStylePropertiesDict(self):
	 for s in self.style_dict.keys():
	     self.style_properties_dict[s] = self.getStylePropertiesDict(s)

     def buildStylePropertiesHierarchical(self):
	 """Built up the style:properties of a style. Example:
	 "P14" derived from "Normal" derived from "Standard". =>
	 Fetch "Standard", then update with "Normal", then
	 update with the automatic-style "P14". => Last defined (automatic-style) overwrites
	 everything before."""
	 for s in self.style_dict.keys():
	     temp_properties = {}
	     list = self.style_hierarchy_dict[s]
	     if list == []:
		 self.style_properties_hierarchical[s] = self.style_properties_dict[s]
             else:
		 newlist = copy.copy(list)
		 newlist.reverse()
		 for n in newlist:
		     # built up the style:properties
		     self.updateWithPercents(dict=temp_properties,updatedict=self.style_properties_dict[n])
		 self.updateWithPercents(dict=temp_properties,updatedict=self.style_properties_dict[s])
                 # add the last style in hierarchy - often this will be an "automatic-style"
		 self.style_properties_hierarchical[s] = temp_properties

     def updateWithPercents(self,dict,updatedict):
	 """Sometimes you find values like "115%" in the style hierarchy."""
         if not updatedict:
              # no style hierarchies for this style? =>
              return
         new_updatedict = copy.copy(updatedict)
	 for u in new_updatedict.keys():
	     try:
		 if new_updatedict[u].find("""%""") != -1 and dict.has_key(u):
		     number = float(self.re_digits.search(dict[u]).group(1))
		     unit = self.re_digits.search(dict[u]).group(2)
		     new_number = self.stringPercentToFloat(new_updatedict[u]) * number
                     if unit == "pt":
                          new_number = int(new_number)
                          # no floats allowed for "pt"
                          # OOo just takes the int, does not round (try it out!)
		     new_updatedict[u] = "%s%s" % (new_number,unit)
		 else:
		     dict[u] = new_updatedict[u]
                     pass
	     except:
                  dict[u] = new_updatedict[u]
         dict.update(new_updatedict)

##     def standardParagraphProperties(self,dict):          
##          print dict
##          """set certain standard properties for paragraphs that always
##          must appear - if not already present.
##          Otherwise you may get bad output when transforming
##          to RML.
##          Was experimental."""
##          standard_properties = {"style:font-name": "Times",
##                                 "fo:font-size": "12pt",
##                                 "fo:text-align": "start"}
##          for k in standard_properties.keys():
##               #if dict.has_key(k):
##               print "attr: ",dict.getAttribute(k)

     def normalizeStyleProperties(self):
          """Transfer all style:style-properties attributes from the
          self.style_properties_hierarchical dict to the automatic-styles
          from content.xml. Use this function to preprocess content.xml for
          XSLT transformations etc.Do not try to implement this function
          with XSlT - believe me, it's a terrible task..."""
          styles_styles = self.styles_dom.getElementsByTagName("style:style")
          automatic_styles = self.content_dom.getElementsByTagName("office:automatic-styles")[0]
          for s in styles_styles:
               automatic_styles.appendChild(s.cloneNode(deep=1))
          content_styles = self.content_dom.getElementsByTagName("style:style")
          # these are the content_styles with styles_styles added!!!
          for s in content_styles:
               try:
                    c = self.findChildrenByName(s,"style:properties")
                    if c == []:
                         # some derived automatic styles do not have "style:properties":
                         temp = self.content_dom.createElement("style:properties")
                         s.appendChild(temp)
                         c = self.findChildrenByName(s,"style:properties")
                    c = c[0]
                    dict = self.style_properties_hierarchical[(s.getAttribute("style:name")).encode("latin-1")]
                    for attribute in dict.keys():
                         c.setAttribute(self.openOfficeStringUtf8(attribute),self.openOfficeStringUtf8(dict[attribute]))
               except:
                    pass
               
     def transferStylesXml(self):
          """Transfer certain sub-trees from styles.xml to the normalized content.xml
          (see above). It is not necessary to do this - for example - with paragraph styles.
          the "normalized" style properties contain all information needed for
          further processing."""
          # TODO: What about table styles etc.?
          page_master = self.page_master
          outline_styles = self.styles_dom.getElementsByTagName("text:outline-style")
          t = self.content_dom.createElement("transferredfromstylesxml")
          self.document.insertBefore(t,self.body)
          t_new = self.body.previousSibling
          try:
               t_new.appendChild(page_master.cloneNode(deep=1))
               t_new.appendChild(outline_styles[0].cloneNode(deep=1))
          except:
               pass

     def normalizeLength(self):
          """Normalize all lengthes to floats (i.e: 1 inch = 72).
          Always use this after "normalizeContent" and "transferStyles"!""" 
          # TODO: The complex attributes of table cell styles are not transferred yet.
          #all_styles = self.content_dom.getElementsByTagName("style:properties")
          #all_styles += self.content_dom.getElementsByTagName("draw:image")
          all_styles = self.content_dom.getElementsByTagName("*")
          for s in all_styles:
               for x in s._attrs.keys():
                    v = s.getAttribute(x)
                    s.setAttribute(x,"%s" % self._lengthToFloat(v))
                    # convert float to string first!

     def normalizeTableColumns(self):
          """Handle this strange table:number-columns-repeated attribute."""
          columns = self.content_dom.getElementsByTagName("table:table-column")
          for c in columns:
               if c.hasAttribute("table:number-columns-repeated"):
                    number = int(c.getAttribute("table:number-columns-repeated"))
                    c.removeAttribute("table:number-columns-repeated")
                    for i in range(number-1):
                         (c.parentNode).insertBefore(c.cloneNode(deep=1),c)

     def buildStyleDict(self):
	 """Store all style:style-nodes from content.xml and styles.xml in self.style_dict.
	 Caution: in this dict the nodes from two dom apis are merged!"""
	 content_styles = self.content_dom.getElementsByTagName("style:style")
	 styles_styles = self.styles_dom.getElementsByTagName("style:style")
	 for s in content_styles:
	     name = s.getAttribute("style:name").encode("latin-1")
	     self.style_dict[name] = s
	 for s in styles_styles:
	     name = s.getAttribute("style:name").encode("latin-1")
	     if not self.style_dict.has_key(name):
		 self.style_dict[name] = s 

     def buildStyleHierarchyDict(self):
	 """Build a list with the parents, grandparents etc. for every stylename."""
	 for s in self.style_dict.keys():
	     ancestors = []
	     temp = self.style_dict[s].getAttribute("style:parent-style-name").encode("latin-1")
	     while temp:
		 ancestors.append(temp)
		 temp = self.style_dict[temp].getAttribute("style:parent-style-name").encode("latin-1")
	     self.style_hierarchy_dict[s] = ancestors

     def toxml(self):
          return self.content_dom.toxml(encoding="utf-8")

     def styles_toxml(self):
	 return self.styles_dom.toxml(encoding="utf-8")

 ##    def replaceTextNodeData(self,text_node,newdata="nix"):
##	 text = text_node.data
##	 new_node = self.content_dom.createTextNode(self.openOfficeStringUtf8(newdata))
##	 (text_node.parentNode).replaceChild(new_node,text_node)

     def cloneNodeWithReplaceListofdictsOpenOffice(self,node,listofdicts,tag_template="""Multi:TFA-%s-TFE"""):
	 """Take a reference node as template,
	 test for "Multi:TFA-...-TFE"-etc. Tags, return a list
	 with cloned nodes and - if necessary - the replaced text.
	 Used for pyopenoffice.PyOpenOffice.makeSerialLetters etc.
         This function is experimental and switched off be default."""
	 clone_list = []
	 temp_xml = node.toxml(encoding="utf-8")
	 if temp_xml.find("Multi:TFA-") == -1:
	     # fast way to exclude nodes without the tags
	     # the test includes the children of the node.
	     return clone_list
	 for dict in listofdicts:
	     newnode = node.cloneNode(deep=1)
	     cloneflag = 0
	     text_nodes = self.findChildrenByNodeType(newnode,newnode.TEXT_NODE)
	     for t in text_nodes:
		 newtext = copy.copy(t.data)
		 for key in dict.keys():
		     tag = tag_template % key
		     if (newtext).find(tag) != -1:
			 newtext = newtext.replace(tag,self.openOfficeStringUtf8(dict[key]))
			 cloneflag = 1
	         if cloneflag:
		     t.data = newtext
	     if cloneflag:
		 clone_list.append(newnode)
	 return clone_list

     def cloneChildrenByNameWithReplaceListofdictsOpenOffice(self,parent,childname,listofdicts,replace=1):
	 list = parent.getElementsByTagName(childname)
	 lod = listofdicts
	 for child in list:
	     print child
	     clone_list = self.cloneNodeWithReplaceListofdictsOpenOffice(node=child,listofdicts=lod)
	     if clone_list:
		 self.insertListOfNodesAfter(child,clone_list)
		 if replace:
		     child.parentNode.removeChild(child)	     

     def testTextNodesForTagsOpenOffice(self,list_of_textnodes,tag="Multi:TFA-"):
	 teststring = ""
	 for l in list_of_textnodes:
	     teststring += l.data
	 if teststring.find(tag) != -1:
	     return 1
	 else:
	     return 0
	 

##     def cloneChildrenByName(self,parent,name,clones=1,replace=0):
##	 """TODO: this function is just for testing..."""
##	 list = parent.getElementsByTagName(name)
##	 #print list
##	 #newchild_list = []
##	 for child in list:
##	     newchild_list = []
##	     for i in range(clones):
##		 newclone = child.cloneNode(deep=1)
##		 text_nodes = self.findChildrenByNodeType(child,child.TEXT_NODE)
##		 for t in text_nodes:
##		     #self.replaceTextNodeData(t,"nix%s" % i)
##		     t.data = "nix%s" % i
##		 newchild_list.append(newclone)
##	     child = self.insertListOfNodesAfter(child,newchild_list)
##	     # correct the reference to child, insertListOfNodesAfter "plays" with the references
##	     if replace:
##		 child.parentNode.removeChild(child)
##	 return
		 
##	     #print newchild
##	     text_nodes = self.findChildrenByNodeType(child,child.TEXT_NODE)
##	     #print "text-nodes: ",text_nodes
##	     for t in text_nodes:
##		 #print "t: ",t
##		 print (t.data).encode("cp1252")
##	     for newchild in newchild_list:
##		 (child.parentNode).insertBefore(newchild,child)
##             #self.cloneChildrenByName(child,name)
     


   ##  def insertListOfNodesBefore(self,refnode,list_of_nodes):
##	 oldref = refnode
##	 newref = self.insertListOfNodesAfter(refnode,list_of_nodes)
##	 return (newref.parentNode).insertBefore(oldref,newref)
    
     def getStyleProperty(self,style_name_or_node,attribute):
          try:
               if type(style_name_or_node) == types.StringType:
                    childs = self.style_dict[style_name_or_node].childNodes
               else:
                    childs = style_name_or_node.childNodes
               for c in childs:
                    if c.nodeType == c.ELEMENT_NODE and c.nodeName == "style:properties":
                         return c.getAttribute(attribute).encode("latin-1")
          except:
               return ""

     def getStylePropertiesDict(self,style_name):
	 tempdict = {}
	 try:
	     childs = self.style_dict[style_name].childNodes
             for c in childs:
		 if c.nodeType == c.ELEMENT_NODE and c.nodeName == "style:properties":
		     attrs = [i.encode("latin-1") for i in c._attrs.keys()]
		     for a in attrs:
			 tempdict[a] = c.getAttribute(a).encode("latin-1")
		     return tempdict
	 except:
              return ""

     def createClipboard(self):
         """A "clipboard" for copy and paste operation in a DOM tree. Experimental.""" 
	 self.clipboard = self.content_dom.createElement("clipboard12345abcde")
	 self.content_dom.documentElement.appendChild(self.clipboard)

     def deleteClipboard(self):
	 if self.clipboard is not None:
	     self.content_dom.documentElement.removeChild(self.clipboard)
	 self.clipboard = None	 

     def getPageMasterProperty(self,attribute):
          return self.getStyleProperty(self.page_master,attribute)
             

class Textutilities:
    def __init__(self):
         self.win, self.win_nt = plattformTesten()

    def csvdatei_einlesen(self,datei="/home/martin/skripte/python/gemeindekartei.txt",trenner="\t",datumumwandeln="nein",nichtaendern=["Telefon","Fax", "EMail"]):
        """Spaltenüberschriften als erste Zeile werden nicht gesondert behandelt!
        Rückgabeformat: Liste von Liste."""
        # *** TODO: Probleme bei leeren Datenfeldern? (repräsentiert z.B. von zwei aufeinanderfolgenden Tabs)
        sortierwerkzeug = sortieren.Sortieren()
        rueck_matrix = []
        try:
            f = open(datei,'r')
        except:
            print "Wo ist Datei %s?" %datei
            return 0
        inhalt = f.readlines()
        ## inhalt = map(lambda x: string.rstrip(x), inhalt)
        ## Alle angehängten Returns weg => nein - Schwierigkeiten bei
        ## Leerfeldern. Wird in importUmwandeln pro Feld gemacht s.u.
        kategorien = string.split(inhalt[0],trenner)
        laenge = len(kategorien)
        ## print kategorien
        for i in inhalt:
            temp = string.split(i,trenner)
            if len(temp) != laenge:
                # print "Content-type: text/html\n"
                print "Importierte Datenbank %s ist inkonsistent bei Element %s." %(datei,temp)
                return 0
            else:
                rueck_matrix.append(temp)        
        f.close()
        # Sonderbehandlungen für jedes Datenfeld:
        rueck_matrix = sortierwerkzeug.mapAll(rueck_matrix,funktion=self.importUmwandeln)
        if datumumwandeln == "ja":            
            temp = sortierwerkzeug.mapAll(rueck_matrix,funktion=self.datumParsen,nichtaendern=nichtaendern)
            return temp
        else:
            return rueck_matrix

    def alsDictionary(self,spalten,array):
        # macht aus einem Array von Array ein
        # Array von Dictionaries, jeweils mit den
        # Namen aus "spalten" als Schlüssel
        temparray = []
        for i in array:
            tempdict = {}
            for j in range(len(spalten)):
                tempdict[spalten[j]] = i[j]
            temparray.append(tempdict)
        return temparray    

    def importUmwandeln(self,string):
         """Gibt an, wie jedes einzelne Datenfeld - unabhängig von
         datumParsen - noch behandelt werden soll."""
         # Einige Tabellenkalkulationen exportieren mit
         # besonderen "Text-Trenner"-Zeichen.
         string = string.replace('\"','')
         string = string.replace("\'","")
         string = string.strip()
         # keine führenden oder angehängten Spaces usw.
         return string
         

    def datumParsen(self,string):
        """gibt ein erkanntes Datum als ISO-String
        JJJJ-MM-TT zurück, sonst den String selbst.
        Erlaubte Eingabeformate: "TT/MM/JJJJ" oder "TT.MM.JJJJ"
        oder "TT. Monatsname(deutsch ohne Abkürzung: "September") JJJJ".
        Ist tolerant gegen fehlende Spaces.
        Damit nicht jedes Textutilities-Objekt die komplizierten Regexes
        kompilieren muß, erscheinen sie nur hier und nicht in __init__."""
        datumsform = re.compile(r"((\d?\d)[\.\/]\s?(\d?\d)[\.\/]\s?(\d\d\d\d))")
        # *** TODO: ggf. noch abgekürzte Monatsnamen wie Apr. oder Mrz. behandeln.
        datumstext = re.compile(r"((\d?\d)\.\s?(Januar|Februar|März|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember)\s?(\d\d\d\d))")
        monate = {"Januar":"01", "Februar":"02", "März":"03", "April":"04","Mai":"05","Juni":"06","Juli":"07","August":"08","September":"09","Oktober":"10","November":"11","Dezember":"12"}
        mobj = datumsform.search(string)
        if mobj is not None:
            # Korrekte Vornullen:
            tag = "%02d" % int(mobj.group(2))
            monat = "%02d" % int(mobj.group(3))
            jahr = "%04d" % int(mobj.group(4))
            return "%s-%s-%s" % (jahr,monat,tag)
        mobj = datumstext.search(string)
        if mobj is not None:
            tag = "%02d" % int(mobj.group(2))
            temp = mobj.group(3)
            jahr = "%04d" % int(mobj.group(4))
            monat = monate[temp]
            return "%s-%s-%s" % (jahr,monat,tag) 
        # Wenn kein Treffer:
        return string
        

    def csvDateiSchreiben(self,matrix,dateiname,trenner="\t",alsString="nein"):
         """Schreibt eine Liste von einer Liste in eine Datei,
         überschreibt ggf. ohne Nachfrage!"""
         string1 = ""         
         for zeile in matrix:
              for spalte in zeile:
                   string1 += """%s%s""" % (spalte,trenner)
              string1 = string1[:-1] + '\n'
              # letzter Tab weg, statt dessen Return
              # *** Achtung bei Windows wg. Zeilentrenner! ***
              # Automatische Umwandlung beim Schreiben?
              # ggf. os.linesep statt "\n" verwenden.
         if alsString == "ja":
              return string1
         else:
              try:
                   file = open(dateiname,'w') 
                   file.write(string1)
                   file.close()
                   return 1
              except:
                   # zur Lesbarkeit in CGI-Umgebungen:
                   print "Content-type: text/html\n"            
                   print "<H3>Konnte nicht in Datei %s schreiben!</H3>" % dateiname
                   return 0
    
    def extract_tags(self, starttag, endtag, startposition, inhalt,mitTags="ja"):
        ## sucht in einem XML/HTML(ähnlichen)-String zwischen denen als Regex-Objekt
        ## angegebenen Tags Tabellen usw.
        startobj = starttag.search(inhalt, startposition)
        if not startobj:
            ## wenn kein Treffer:
            return ('',0)     
        endobj = endtag.search(inhalt, startposition)
        # TODO:
        if not endobj:
             # for example for empty paragraphs: <text:p ....... />
             return ('',startposition+1)
        if mitTags == "ja":
             startposition = startobj.start()
             endposition = endobj.end()
        elif mitTags == "nein":
             startposition = startobj.end()
             endposition = endobj.start()
        # print startposition, endposition
        if (startposition <= endposition):    
            extractstring = inhalt[startposition:endposition]
            # TODO:
            # print endposition
            return (extractstring, endposition)
        else:
            sys.exit("Ober- und Untergrenze vertauscht in textutilities.extract_tags!")

    def remove_tags_all(self,starttag,endtag,inhalt,mitTags="ja"):
         """Extract all from a text="inhalt" that is between the defined tags.
         Example: remove all ordered lists from content.xml."""
         list = self.extract_tags_all(starttag=starttag,endtag=endtag,inhalt=inhalt,mitTags=mitTags)
         for l in list:
              inhalt = inhalt.replace(l,"")
         return inhalt

    def extract_tags_all(self,starttag,endtag,inhalt,mitTags="ja"):
       """Like extract_tags, but returns a list of all matches."""
       startposition = 0
       list = []
       temp = self.extract_tags(starttag=starttag,endtag=endtag,startposition=startposition,inhalt=inhalt,mitTags=mitTags)
       while temp[0]:
          list.append(temp[0])
          startposition = temp[1]
          temp = self.extract_tags(starttag,endtag,startposition,inhalt,mitTags=mitTags)
       return list

    def remove_tags(self, starttag, endtag, inhalt,mitTags="ja"):
        ## Beseitigt aus einem Text alles zwischen starttag und endtag
        ## auch bei mehreren Vorkommen. starttag und endtag sind
        ## re-Objekte, s.o. Bei mitTags = "ja" werden auch die Tags mitgelöscht.
        position = 0
        ausgabe = ""
        ##temp = ""
        while 1:
            startobj = starttag.search(inhalt,position)
            if not startobj:
                 ## für den "Schwanz":
                 if mitTags == "ja":
                      ausgabe = ausgabe+inhalt[position:]
                 else:
                      ausgabe = ausgabe+inhalt[endobj.start():]
                 break                
            else:
                 endobj = endtag.search(inhalt,position)
                 startposition = startobj.start()
                 endposition = endobj.end()
                 if mitTags == "ja":
                      ausgabe = ausgabe+inhalt[position:startposition]
                 else:
                      ausgabe = ausgabe+inhalt[position:startobj.end()]
                 position = endposition                
        return ausgabe

    def bildschirmLoeschen(self):
         """Arbeitet mit ANSI-Escape-Sequenzen. Für DOS nicht vergessen,
         ansi.sys einzubinden."""
         print "\033[2J"
         print "\033[0;0H"

    def konfigurationEinlesen(self,text):
         """Liest einen Text (z.B. aus einer Konfigurationsdatei) ein, gibt die Daten
         in einem Dictionary zurück. Primitiv und nicht sehr fehlertolerant. Windows-geeignet?
         (Wegen Zeilenendezeichen)"""
         alleZeilen = text.split("\n")
         datendict = {}
         for i in alleZeilen:
              try:
                   if i[0] == "#":
                        # Kommentarzeilen überspringen.
                        continue
                   i = i.rstrip()
                   templist = i.split("=")
                   datendict[templist[0]] = "%s" % templist[1]
              except:
                   # hier werden z.B. leere oder falsche Zeilen behandelt:
                   pass
         return datendict

    def schluesselworteFinden(self,text,wortliste,ohneSpaces="ja"):
         if ohneSpaces == "ja":
              text = text.strip()
              wortliste = [i.strip() for i in wortliste]
         templist = []
         for i in wortliste:
              if text.find(i) != -1:
                   templist.append(i)
         return templist

    def schluesselworteExtrahieren(self,text,wortliste,ohneSpaces="ja"):
         """Entfernt aus einem String alle Wörter aus Wortliste."""
         if ohneSpaces == "ja":
              text = text.strip()
              wortliste = [i.strip() for i in wortliste]
              # wenn text und wortliste aus einer Datenbank o.a. stammen, könnten vorne oder hinten
              # z.B. Spaces sein.
         for wort in wortliste:
              text = text.replace(wort,"")
         return text

    def abkuerzungenTesten(self,text,wortliste):
         """Soll einen Text darauf testen, ob er lediglich eine Anzahl von Abkürzungen
         enthält, ggf. getrennt durch Spaces, Kommas usw. z.B. für Tests von
         Datenbankfeldern."""
         ohne_schluessel_text = self.schluesselworteExtrahieren(text,wortliste,ohneSpaces="ja")
         dict = {" ": None, "\n": None, ",": None, ";": None, "\"": None, "\'": None}
         # so nutzen wir den schnellen Hash-Algorithmus der dict-Klasse, um ggf. Trenner-
         # zeichen u.ä. zu entfernen.
         returntext = ""
         for i in ohne_schluessel_text:
              if dict.has_key(i):
                   continue
              else:
                   returntext += i
         # wenn returntext immer noch "", dann waren im zu testenden Text nur
         # gültige Abkürzungen.
         return {"TestText": returntext,"ReduzierterText": ohne_schluessel_text}

    def stringErsetzenDatei(self,datei,stringalt,stringneu):
         """Eine sichere Methode, einen String zu ersetzen in einer Datei.
         berücksichtigt das verzögerte Setzen von Rechten bei Windows usw."""
         os.chmod(datei,0777)
         tempfile = open(datei,"rb")
         inhalt = tempfile.read()
         tempfile.close()
         inhalt = string.replace(inhalt,stringalt,stringneu)
         os.chmod(datei,0777)
         if self.win:
              time.sleep(1)            
              # eine Zeitschleife, weil (liegt es daran?) in Windows
              # manchmal die Schreibberechtigung zu spät gesetzt wird.
         tempfile = open(datei,"wb")
         tempfile.write(inhalt)
         tempfile.close()

    def openOfficeLesen(self,datei,archiv_datei="content.xml",RML=0):
         """Liest die content.xml-Datei eines OO-"Archivs", oder eine andere angegebene."""
         if RML:
              file = open(datei,"rb")
              inhalt = file.read()
              file.close()
              return inhalt
         z = zipfile.ZipFile(datei,"r")
         inhalt = z.read(archiv_datei)
         z.close()
         return inhalt

    def openOfficePagebreakstyle(self):
         """Very primitive. Assumes that you will never more than 2000 automatic-styles..."""
         return """ <style:style style:name="P2000" style:family="paragraph" style:parent-style-name="Standard"><style:properties fo:break-after="page"></style:properties></style:style>"""

    def openOfficePagebreakstyleEinsetzen(self,content):
         if content.find("style:name=\"P2000\"") == -1:
              return content.replace("""</office:automatic-styles>""",self.openOfficePagebreakstyle()+"""</office:automatic-styles>""")
         else:
              return content

    def openOfficeMergetextPruefen(self,text):
         """Manche XML-Styles machen bei dieser primitiven Merge-Methode Probleme,
         deshalb dieser Test. Achtung, überall nur reine ASCII-Zeichen nehmen, keine Umlaute!"""
         rueckgabe = text
         flag = 1
         testdict = {"text:anchor-type=\"page\"": {"Beschreibung": "Verankerung an der Seite","Ersatz": "Verankerung am Absatz"}}
         # Dieser testdict kann ergänzt werden.
         for style in testdict.keys():
              if (rueckgabe.find(style) != -1) and VERBOSE:
                   warntext = """Problem: Ihr(e) OpenOffice-Dokument(vorlage) enthaelt irgendwo das Element "%s" (XML: %s). Ersetzungsvorschlag: "%s".#####""" % (testdict[style]["Beschreibung"],style,testdict[style]["Ersatz"])
                   # Achtung, Test:
                   print "Content-type: text/html\n"
                   print "<H3>"+warntext+"</H3>"
                   flag = 0
         return flag              

    def openOfficeMerge(self,content1,content2,pagebreak="ja",RML=0):
         """Ergänzt bei der content.xml-Datei des ersten OO-Archivs in <office:body> den Inhalt von
         <office:body> der zweiten Datei. Nur die automatic-styles der ersten Datei werden übernommen.
         Merge two OO files: take the content.xml of the first file. Append the <office:body..> of the second content.xml
         to the first <office:body...>. If pagebreak="ja", the two contents are separated by a pagebreak.
         With RML = 1 you can process RML files."""
         if RML:
              body_start = re.compile(r"<story>")
              body_end = re.compile(r"<\/story>")
         else:
              body_start = re.compile(r"<office:body>")
              body_end = re.compile(r"<\/office:body>")
         body_1 = self.extract_tags(body_start,body_end,0,content1,mitTags="nein")[0]
         body_2 = self.extract_tags(body_start,body_end,0,content2,mitTags="nein")[0]
         if not RML:
              self.openOfficeMergetextPruefen(body_2)
         content_neu = self.remove_tags(body_start,body_end,content1,mitTags="nein")
         if pagebreak == "ja":
              if not RML:
                   content_neu = self.openOfficePagebreakstyleEinsetzen(content_neu)
                   return content_neu.replace("<office:body>","<office:body>"+body_1+"""<text:p text:style-name="P2000" />"""+body_2)
              else:
                   return content_neu.replace("<story>","<story>"+body_1+"""<pageBreak/>"""+body_2)
         else:
              if not RML:
                   return content_neu.replace("<office:body>","<office:body>"+body_1+body_2)
              else:
                   return content_neu.replace("<story>","<story>"+body_1+body_2)

    def openOfficeErsetzen(self,datei,inhalt,neuedatei=None,archiv_datei="content.xml",RML=0):
         datei = datei
         if neuedatei:
              shutil.copyfile(datei,neuedatei)
              datei = neuedatei
         if RML:
              file = open(datei,"wb")
              file.write(inhalt)
              file.close()
              return
         # Achtung, Windows-Falle?
         # os.chmod(datei,0777)
         # evtl. noch s.o.:
         #if self.win:
         #     time.sleep(1)
         z = zipfile.ZipFile(datei,"r")
         zipinfo = z.getinfo(archiv_datei)
         z.close()
         z = zipfile.ZipFile(datei,"a")
         z.writestr(zipinfo,inhalt)
         z.close()

    def openOfficeReplacePictures(self,file,pic_list):
         """Try to replace all embedded pictures by the content
         of the files from pic_list. Keep the order in the sxw-file
         and map it to the order from pic_list.
         Return the filename of the generated file.
         If no replacement was possible, the name of the original file will be returned."""
         tempfile = open(file,"rb")
         file_content = tempfile.read()
         tempfile.close()
         # save content of the template file
         import Image
         content = self.openOfficeLesen(file)
         re_pic = re.compile(r"xlink:href=\"#Pictures/(.*?)\"",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_im = re.compile(r"(<draw:image.*?(svg:width=\"(.*?)(cm|inch)\").*?(svg:height=\"(.*?)(cm|inch)\").*?(xlink:href=\"#Pictures/(.*?)\").*?>)",re.DOTALL | re.IGNORECASE | re.UNICODE)
         all = re_im.findall(content)
         list = re_pic.findall(content)
         check = file
         if (list == []) or (pic_list == []):
              return file
         try:
              for index in range(len(list)):
                   whole_pic = all[index][0]
                   if index > len(pic_list)-1:
                        content = content.replace(whole_pic,"")
                        # go on to the next picture to be replaced with empty space:
                        continue
                   #print "index: ",index
                   im = Image.open(pic_list[index])
                   #print "size: ", im.size
                   proportion = float(im.size[1])/float(im.size[0])
                   # the proportion of the new picture to be embedded.
                   pic_file = all[index][8]
                   height = all[index][4]
                   heigth_value_string = all[index][5]
                   width_value = float(all[index][2])
                   new_height_string = "%s" % (width_value * proportion)
                   new_height = height.replace(heigth_value_string,new_height_string)
                   new_picfilename = pic_file.split(".")[0] + pic_list[index]
                   # do not use the filenname of the inserted picture file to store it in the sxw-file:
                   # the file may be deleted by the house cleaning routine of makeSafePdf().
                   new_whole_pic = whole_pic.replace(pic_file,self.openOfficeStringUtf8(new_picfilename))
                   new_whole_pic = new_whole_pic.replace(height,new_height)
                   #print "old_height: ", height
                   #print "new_height: ",new_height
                   content = content.replace(whole_pic,new_whole_pic)
                   self.openOfficeReplacePictureFile(file=file,old_pic=list[index],new_pic=pic_list[index],new_picfilename=new_picfilename)
              self.openOfficeErsetzen(datei=file,inhalt=content,neuedatei="NewPics_"+file)
              tempfile = open(file,"wb")
              tempfile.write(file_content)
              tempfile.close()
              # restore template file
              check = "NewPics_" + file
         except:
              pass
         return check

    def openOfficeUnpackArchive(self,sourcefile):
         """Unpacks the whole OO archive into the current directory,
         content of subdirectories (like Pictures/) included.
         Returns a list of the written files (for cleanup purposes etc.)."""
         unpacked = []
         try:
              z = zipfile.ZipFile(sourcefile,"r")
              all = z.namelist()
              for a in all:
                   content = z.read(a)
                   name = os.path.basename(a)
                   new_file = open(name,"wb")
                   new_file.write(content)
                   new_file.close()
                   unpacked.append(name)
              z.close()
              return unpacked
         except:
              return []

    def openOfficeReplacePictureFile(self,file,old_pic,new_pic,new_picfilename):
         """Replace a file of the Pictures-Directory in
         the sxw-archive."""
         check = 0
         try:
            z = zipfile.ZipFile(file,"r")
            zipinfo = z.getinfo("Pictures/" + old_pic)
            z.close()
            z = zipfile.ZipFile(file,"a")           
            z.writestr(zipinfo,"")
            # replace old_pic by an empty string to save space.
            # TODO: the old_pic is not deleted in the Pictures-directory of the
            # sxw-archive. Seems to be no problem.
            z.write(new_pic,"Pictures/" + new_picfilename)
            z.close()
            check = 1
         except:
            pass
         return check

    def openOfficeReplaceKeyCheck(self,string,list_of_keys,multi=0):
         """Checks the string for TFA-key-TFE or Multi:TFA-key-TFE fields.
         Returns 1, if at least one field is in the string."""
         returnflag = 0
         field = """TFA-%s-TFE"""
         if multi:
              field = """Multi:TFA-%s-TFE"""
         for key in list_of_keys:
              if string.find((field % key)) != -1:
                   returnflag = 1
         return returnflag
              

    def openOfficeMultiReplaceTables(self,content,listofdicts,tags=("TFA-","-TFE"),RML=0):
       """Replaces one table-row with the records from listofdicts.
       TODO: is it useful to use other tags?"""
       newcontent = copy.copy(content)
       if not RML:
            re_table_left = re.compile(r"<table:table.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_table_right = re.compile(r"</table:table>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_row_left = re.compile(r"<table:table-row.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_row_right = re.compile(r"</table:table-row>",re.DOTALL | re.IGNORECASE | re.UNICODE)
       else:
            re_table_left = re.compile(r"<blockTable.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_table_right = re.compile(r"</blockTable>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_row_left = re.compile(r"<tr.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_row_right = re.compile(r"</tr>",re.DOTALL | re.IGNORECASE | re.UNICODE)
            re_table_name = re.compile(r"<blockTable.*?style=\"(.*?)\".*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
       tables = self.extract_tags_all(starttag=re_table_left,endtag=re_table_right,inhalt=content)
       for table in tables:
            old_table = copy.copy(table)
            rows = self.extract_tags_all(starttag=re_row_left,endtag=re_row_right,inhalt=table)
            row_counter = -1 # the first row should be "0"
            if RML:
                 table_name = re_table_name.findall(table)[0]
            for row in rows:
                 row_counter += 1
                 temptext = ""
                 if row.find("Multi:TFA-") != -1:
                     offset_counter = -1 # first offset should be zero 
                     for dict in listofdicts:
                          if not self.openOfficeReplaceKeyCheck(string=row,list_of_keys=dict.keys(),multi=1):
                               continue
                          new_row = copy.copy(row)
                          for key in dict.keys():
                               # TODO: only use hardcoded tags?
                               new_row = new_row.replace(self.openOfficeStringUtf8("Multi:TFA-%s-TFE" % key), self.openOfficeStringUtf8(dict[key]))
                          temptext += new_row
                          offset_counter += 1
                     table = table.replace(row,temptext)
                     if RML:
                          # adapt the cell colours etc. in blockTableStyle:
                          api = DomApiGeneral(content_string=newcontent,parse_all=0)
                          api.adaptBlockTableStyle(style=table_name,row=row_counter,offset=offset_counter)
                          newcontent = api.content_string
                          #print newcontent
                 else:
                      # rows without Multi-Fields are left as they are
                      pass        
            newcontent = newcontent.replace(old_table,table)
       return newcontent

    def openOfficeRemoveLists(self,content):
         """Remove all ordered and unordered lists from content."""
         re_orderedList_left = re.compile(r"<text:ordered-list.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_orderedList_right = re.compile(r"</text:ordered-list>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_unorderedList_left = re.compile(r"<text:unordered-list.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_unorderedList_right = re.compile(r"</text:unordered-list>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         content = self.remove_tags_all(starttag=re_orderedList_left,endtag=re_orderedList_right,inhalt=content,mitTags="ja")
         return self.remove_tags_all(starttag=re_unorderedList_left,endtag=re_unorderedList_right,inhalt=content,mitTags="ja")          

    def openOfficeReplaceLinebreaks(self,content,RML=0):
         """Replace all linebreaks (<text:line-break/>) by an appropriate number of paragraphs.
         This is necessary for example when you want to generate PDF: Platypus does not know
         intra-Paragraph linebreaks.
         It works also with an RML file with the (non-RML) tags <text:line-break/> in it.
         Use this function last when everything else is done (like serial letters etc.).
         It is very fast even with large contents."""
         if not RML:
              re_paragraph_left = re.compile(r"<text:p.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
              re_paragraph_right = re.compile(r"</text:p>",re.DOTALL | re.IGNORECASE | re.UNICODE)
              paragraph_end = """</text:p>"""
         else:              
              re_paragraph_left = re.compile(r"<para.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
              re_paragraph_right = re.compile(r"</para>",re.DOTALL | re.IGNORECASE | re.UNICODE)
              paragraph_end = """</para>"""
         linebreak = self.openOfficeStringUtf8("""<text:line-break/>""")
         # use this also as an RML pseudo-tag (replace them when you are using a validating parser!!!)
         newcontent = copy.copy(content)
         newcontent = self.openOfficeRemoveEmptyParagraphs(newcontent,RML=RML)
         if not RML:
              newcontent = self.openOfficeRemoveLists(newcontent)
              # no list structures in RML
         # remove all empty paragraphs first - otherwise the extract_tags_all will not work properly.
         # also extract all lists, keep the linebreaks
         # (otherwise you will not convert them properly to PDF). Then extract the matching paragraphs:
         paragraphs = self.extract_tags_all(starttag=re_paragraph_left,endtag=re_paragraph_right,inhalt=newcontent)
         for p in paragraphs:
              if p.find(linebreak) == -1:
                   continue
              p_left = self.openOfficeStringUtf8(re_paragraph_left.findall(p)[0])
              replacestring = self.openOfficeStringUtf8(paragraph_end) + p_left
              new_p = p.replace(linebreak,replacestring)
              # you have to work on the original content!!! =>
              content = content.replace(p,new_p)              
         return content

    def openOfficeDataWithLinebreaks(self,listofdicts):
         """Use this, when you want to process data from a database etc. with linebreaks."""
         linebreaks = ("\r\n","\n","\r")
         # mind the order above!
         lb = self.openOfficeStringUtf8("""<text:line-break/>""")
         for dict in listofdicts:
              for key in dict.keys():
                   for sign in linebreaks:
                        try:
                             dict[key] = dict[key].replace(sign,lb)
                        except:
                             pass
         return listofdicts                        

    def openOfficeMultiReplaceParagraphs(self,content,listofdicts,tags=("TFA-","-TFE")):
         """Replaces one paragraph with the records from listofdicts. Use the line-break-sign in the
         sxw-document (shift-return in OO) instead of carriage-return to print multi-line-records
         for example: Surname - linebreak - First Name - linebreak - City.
         TODO: this function is not safe yet. It is switched off by default."""
         re_paragraph_left = re.compile(r"<text:p.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_paragraph_right = re.compile(r"</text:p>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_paragraph_empty = re.compile(r"<text:p.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_table_left = re.compile(r"<table:table.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         re_table_right = re.compile(r"</table:table>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         oldcontent = copy.copy(content)
         content = self.remove_tags(starttag=re_table_left,endtag=re_table_right,inhalt=content) 
         content = self.openOfficeRemoveEmptyParagraphs(content)
         # remove all tables and empty paragraphs first. Then extract:
         paragraphs = self.extract_tags_all(starttag=re_paragraph_left,endtag=re_paragraph_right,inhalt=content)
         for p in paragraphs:
              old_p = ""
              temptext = ""
              if p.find("Multi:TFA-") != -1:
                   for dict in listofdicts:
                        old_p = copy.copy(p)
                        for key in dict.keys():
                             old_p = old_p.replace(self.openOfficeStringUtf8("Multi:TFA-%s-TFE" % key), self.openOfficeStringUtf8(dict[key]))
                        temptext += old_p
              oldcontent = oldcontent.replace(p,temptext)
         return oldcontent

    def openOfficeRemoveEmptyParagraphs(self,content,RML=0):
         """Removes all empty paragraphs from content."""
         if not RML:
              re_paragraph_start = re.compile(r"<text:p.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         else:
              re_paragraph_start = re.compile(r"<para.*?>",re.DOTALL | re.IGNORECASE | re.UNICODE)
         list = re_paragraph_start.findall(content)
         for p in list:
              if p[-2:] == "/>":
                   # print "hier"
                   content = content.replace(p,"")
         return content
       
    def openOfficeMultiReplace(self,sourcefile,replace_listofdicts,tags=("TFA-","-TFE"),as_file=1,with_paragraphs=0,content="",RML=0):
         """Multiple replace of tables-rows and paragraphs. Working without an XML-Parser - fast, but primitive.
         Use only custom fields with pure ASCII-Sign - not "TFA-GermanUmlauteÄÖÜ-TFE" etc.
         In content you may provide pre-processed content (see below)."""
         if not content:
              content = self.openOfficeLesen(sourcefile,RML=RML)         
         file = "Multi%s_%s" % (len(replace_listofdicts),os.path.basename(sourcefile))
         newcontent = self.openOfficeMultiReplaceTables(content=content,listofdicts = replace_listofdicts,RML=RML)
         # ****** very important: replace table-rows first - table-cells consist of paragraphs! ******
         if with_paragraphs:
              newcontent = self.openOfficeMultiReplaceParagraphs(content=newcontent,listofdicts = replace_listofdicts)
         if as_file:
              self.openOfficeErsetzen(datei=sourcefile,inhalt=newcontent,neuedatei=file,RML=RML)
              return file
         else:
              return newcontent

    def openOfficeSerialLetter(self,sourcefile,replace_listofdicts,one_file=1,tags=("TFA-","-TFE"),content="",replace_fixeddict=defaultkeywords,RML=0,transform_linebreaks=0):
         """Takes an sxw-file and a list of dictionaries, makes many documents from it
         by replacement. The startag and endtag defaults are from the "Bezirksreiter"-Software.
         If one_file is set to 0, it will be saved as one document per record, otherwise everything
         will be in one document. When using frames in the sxw-document: do not use "anchor-type:page".
         Working without an XML-Parser: fast, but primitive.
         With RML = 1 you also can process files in the Reportlab Markup Language.
         You may pass a preprocessed content(i.e. the content of content.xml).
         With transform_linebreaks=1 you turn OOo linebreaks into paragraphs.
         TODO: the tags only may contain ascii-signs.
         Use only custom fields with pure ASCII-Sign - not "TFA-GermanUmlauteÄÖÜ-TFE" etc."""
         if not content:
              # different for RML:
              content = self.openOfficeLesen(sourcefile,RML=RML)
         counter = 0
         outcontent = ""
         for key in replace_fixeddict.keys():
              content = content.replace("TFA-%s-TFE" % key, self.openOfficeStringUtf8(replace_fixeddict[key]))
         first_time = 1
         file_list = []
         found_replace_field = 0
         for record in replace_listofdicts:
              if not self.openOfficeReplaceKeyCheck(string=content,list_of_keys=record.keys(),multi=0):
                   continue # skip "strange" records
              newcontent = copy.copy(content)
              for key in record.keys():
                   replace = escape(record[key])
                   replace = self.openOfficeStringUtf8(replace.replace("""&lt;text:line-break/&gt;""","""<text:line-break/>"""))
                   # New: escape the inserted data - so you can use strings like "Miller & Sons".
                   # Mind: do not escape the inserted OO linebreaks."
                   utf_key = self.openOfficeStringUtf8(key)
                   if newcontent.find("""%s%s%s""" % (tags[0],utf_key,tags[1]))   != -1:
                        #print utf_key
                        found_replace_field = 1 # at least one replace_field?
                   newcontent = newcontent.replace("""%s%s%s""" % (tags[0],utf_key,tags[1]),replace)
              if found_replace_field:
                   counter += 1
                   if one_file:
                        if first_time:
                             outcontent = copy.copy(newcontent)
                             first_time = 0
                        else:
                             # different for RML:
                             outcontent = self.openOfficeMerge(content1=outcontent,content2=newcontent,RML=RML)
                   else:
                        file = "%s_%s" % (counter,os.path.basename(sourcefile))
                        file_list.append(file)
                        # different for RML
                        if transform_linebreaks:
                             newcontent = self.openOfficeReplaceLinebreaks(content=newcontent,RML=RML)
                        self.openOfficeErsetzen(datei=sourcefile,inhalt=newcontent,neuedatei=file,RML=RML)
         if not found_replace_field:
              # no replace_fields found:
              new_file = "1Copies_%s" % os.path.basename(sourcefile)
              file_list = [new_file]
              # different for RML:
              if transform_linebreaks:
                   content = self.openOfficeReplaceLinebreaks(content=content,RML=RML)
              self.openOfficeErsetzen(datei=sourcefile,inhalt=content,neuedatei=new_file,RML=RML)
              if one_file:
                   return new_file
              else:
                   return file_list              
         if one_file:
              new_file = "%sCopies_%s" % (counter,os.path.basename(sourcefile))
              # different for RML:
              if transform_linebreaks:
                   outcontent = self.openOfficeReplaceLinebreaks(content=outcontent,RML=RML)
              self.openOfficeErsetzen(datei=sourcefile,inhalt=outcontent,neuedatei=new_file,RML=RML)
              return new_file
         else:
              return file_list

    def heute(self):
        """Current date in German form."""
        _time = time.strftime('%d.%m.%Y', time.localtime(time.time()))
        return _time

    def today(self):
         """Current date"""
         _time = time.strftime('%d/%m/%Y', time.localtime(time.time()))
         return _time

    def openOfficeStringUtf8(self,string):
         if type(string) == unicode:
              # for Asian fonts etc.:
              return string.encode("utf-8")
         tempstring = unicode(string,"cp1252").encode("utf-8")
         return tempstring

    def openOfficeStringErsetzenDatei(self,datei,stringalt,stringneu):
         tempstring = self.openOfficeStringUtf8(stringneu)
         # wenn Umlaute etc. als neuer String eingesetzt werden.
         inhalt = self.openOfficeLesen(datei)
         inhalt = inhalt.replace(stringalt,tempstring)
         # stringalt darf keine Umlaute enthalten!
         self.openOfficeErsetzen(datei,inhalt)
         return 1    

    def privatStattDienstlich(self,dict):
        """Setzt bei  nicht vorhandener Dienstadresse die Privatadresse ein.
        Speziell für Datenbank vom Typ emkadressen_neu"""
        trans = {"Strasse": "PrivatStrasse",
                 "Land": "PrivatLand",
                 "PLZ": "PrivatPLZ",
                 "Ort": "PrivatOrt",
                 "Telefon": "PrivatTelefon",
                 "Mail": "PrivatMail",
                 "Handy": "PrivatHandy",
                 "Fax": "PrivatFax"}
        tempdict = {}
        tempdict.update(dict)
        try:
             for t in trans.keys():
                  if tempdict[t] == "-" or tempdict[t] == "":
                       tempdict[t] = tempdict[trans[t]]
        except:
             pass # wenn ein leerer dict übergeben wurde.
        return tempdict

    def privatStattDienstlichDictarray(self,dictarray):
        # Achtung, neues Dictarray muss erzeugt werden! 
        tempdictarray = []
        try:
             for i in dictarray:
                 tempdictarray.append(self.privatStattDienstlich(i))
             return tempdictarray
        except:
             return dictarray # leerer dictarray s.o. 

